% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InventoryService.R
\name{dfp_createAdUnits}
\alias{dfp_createAdUnits}
\title{InventoryService}
\usage{
dfp_createAdUnits(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createAdUnitsResponse
}
\description{
Provides operations for creating, updating and retrieving AdUnit objects.
}
\details{
Line items connect a creative with its associated ad unit through
targeting.
An ad unit represents a piece of inventory within a
publisher. It contains all the settings that need to be associated with the
inventory in order to serve ads. For example, the ad unit contains creative
size restrictions and AdSense settings.

createAdUnits

Creates new AdUnit objects.
}
\examples{
\dontrun{
 res <- dfp_createAdUnits(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/InventoryService#createAdUnits}{Google Documentation for createAdUnits}
}
