% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProposalLineItemService.R
\name{dfp_getProposalLineItemsByStatement}
\alias{dfp_getProposalLineItemsByStatement}
\title{getProposalLineItemsByStatement}
\usage{
dfp_getProposalLineItemsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getProposalLineItemsByStatementResponse
}
\description{
Gets a ProposalLineItemPage of ProposalLineItem objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{name}
  \item{proposalId}
  \item{startDateTime}
  \item{endDateTime}
  \item{isArchived}
  \item{lastModifiedDateTime}
  \item{useThirdPartyAdServerFromProposal  Only applicable for non-programmatic proposal line items using sales management}
  \item{thirdPartyAdServerId  Only applicable for non-programmatic proposal line items using sales management}
  \item{customThirdPartyAdServerName  Only applicable for non-programmatic proposal line items using sales management}
  \item{isProgrammatic}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getProposalLineItemsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ProposalLineItemService#getProposalLineItemsByStatement}{Google Documentation for getProposalLineItemsByStatement}
}
