% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserTeamAssociationService.R
\name{dfp_createUserTeamAssociations}
\alias{dfp_createUserTeamAssociations}
\title{UserTeamAssociationService}
\usage{
dfp_createUserTeamAssociations(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createUserTeamAssociationsResponse
}
\description{
Provides methods for creating, updating, and retrieving UserTeamAssociation
objects.
UserTeamAssociation objects are used to add users to teams in
order to define access to entities such as companies, inventory and orders
and to override the team's access type to orders for a user.
}
\details{
createUserTeamAssociations

Creates new UserTeamAssociation objects.
}
\examples{
\dontrun{
request_data <- data.frame(teamid=rep(dfp_createTeams_result$id, 3),
                           userid=dfp_createUsers_result$id)
result <- dfp_createUserTeamAssociations(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/UserTeamAssociationService#createUserTeamAssociations}{Google Documentation for createUserTeamAssociations}
}
