% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductService.R
\name{dfp_createProducts}
\alias{dfp_createProducts}
\title{ProductService}
\usage{
dfp_createProducts(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createProductsResponse
}
\description{
Provides methods for updating and retrieving Product objects.
A Product
represents a line item proposal. Products are generated from
ProductTemplate product templates on a periodic basis using the product
template's attributes. Products are typically used by inventory managers to
restrict what salespeople can sell.
To use this service, you need to
have the new sales management solution enabled on your network. If you do
not see a "Sales" tab in \href{https://www.google.com/dfp}{DoubleClick for
Publishers (DFP)}, you will not be able to use this service.
}
\details{
createProducts

Creates new Product objects. This method is only available when creating programmatic guaranteed products when not using sales management.
}
\examples{
\dontrun{
 res <- dfp_createProducts(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ProductService#createProducts}{Google Documentation for createProducts}
}
