% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaModVar.R
\docType{class}
\name{BetaModVar}
\alias{BetaModVar}
\title{A model variable whose uncertainty follows a Beta distribution}
\description{
An R6 class representing a model variable whose uncertainty
is described by a Beta distribution.
}
\details{
A model variable for which the uncertainty in the point estimate can
be modelled with a Beta distribution. The hyperparameters of the
distribution are the shape parameters (\code{alpha} and \code{beta}) of
the uncertainty distribution. Inherits from class \code{ModVar}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{BetaModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BetaModVar$new()}}
\item \href{#method-is_probabilistic}{\code{BetaModVar$is_probabilistic()}}
\item \href{#method-clone}{\code{BetaModVar$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="SD">}\href{../../rdecision/html/ModVar.html#method-SD}{\code{rdecision::ModVar$SD()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description">}\href{../../rdecision/html/ModVar.html#method-description}{\code{rdecision::ModVar$description()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="distribution">}\href{../../rdecision/html/ModVar.html#method-distribution}{\code{rdecision::ModVar$distribution()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="get">}\href{../../rdecision/html/ModVar.html#method-get}{\code{rdecision::ModVar$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression">}\href{../../rdecision/html/ModVar.html#method-is_expression}{\code{rdecision::ModVar$is_expression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mean">}\href{../../rdecision/html/ModVar.html#method-mean}{\code{rdecision::ModVar$mean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mode">}\href{../../rdecision/html/ModVar.html#method-mode}{\code{rdecision::ModVar$mode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="quantile">}\href{../../rdecision/html/ModVar.html#method-quantile}{\code{rdecision::ModVar$quantile()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="r">}\href{../../rdecision/html/ModVar.html#method-r}{\code{rdecision::ModVar$r()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="set">}\href{../../rdecision/html/ModVar.html#method-set}{\code{rdecision::ModVar$set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units">}\href{../../rdecision/html/ModVar.html#method-units}{\code{rdecision::ModVar$units()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of class \code{BetaModVar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BetaModVar$new(description, units, alpha, beta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string describing the variable.}

\item{\code{units}}{Units of the variable, as character string.}

\item{\code{alpha}}{parameter of the Beta distribution.}

\item{\code{beta}}{parameter of the Beta distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{BetaModVar}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, 
i.e. a random variable that follows a distribution, or an expression
involving random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BetaModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BetaModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
