% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Digraph.R
\docType{class}
\name{Digraph}
\alias{Digraph}
\title{\verb{Digraph} class}
\description{
An R6 class to represent a digraph (a directed graph).
}
\details{
Encapsulates, and provides methods for computation and checking of directed
graphs (digraphs). Inherits from class Graph.
}
\references{
{ 
  Gross JL, Yellen J, Zhang P. Handbook of Graph Theory. Second edition, 
  Chapman and Hall/CRC.; 2013, \doi{10.1201/b16132}.

  Kahn AB, Topological Sorting of Large Networks, 
  \emph{Communications of the \acronym{ACM}},
  1962;\strong{5}:558-562, \doi{10.1145/368996.369025}.
}
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Graph]{rdecision::Graph}} -> \code{Digraph}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Digraph$new()}}
\item \href{#method-digraph_adjacency_matrix}{\code{Digraph$digraph_adjacency_matrix()}}
\item \href{#method-digraph_incidence_matrix}{\code{Digraph$digraph_incidence_matrix()}}
\item \href{#method-topological_sort}{\code{Digraph$topological_sort()}}
\item \href{#method-is_connected}{\code{Digraph$is_connected()}}
\item \href{#method-is_weakly_connected}{\code{Digraph$is_weakly_connected()}}
\item \href{#method-is_acyclic}{\code{Digraph$is_acyclic()}}
\item \href{#method-is_tree}{\code{Digraph$is_tree()}}
\item \href{#method-is_polytree}{\code{Digraph$is_polytree()}}
\item \href{#method-is_arborescence}{\code{Digraph$is_arborescence()}}
\item \href{#method-direct_successors}{\code{Digraph$direct_successors()}}
\item \href{#method-direct_predecessors}{\code{Digraph$direct_predecessors()}}
\item \href{#method-paths}{\code{Digraph$paths()}}
\item \href{#method-walk}{\code{Digraph$walk()}}
\item \href{#method-clone}{\code{Digraph$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="degree">}\href{../../rdecision/html/Graph.html#method-degree}{\code{rdecision::Graph$degree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_index">}\href{../../rdecision/html/Graph.html#method-edge_index}{\code{rdecision::Graph$edge_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="graph_adjacency_matrix">}\href{../../rdecision/html/Graph.html#method-graph_adjacency_matrix}{\code{rdecision::Graph$graph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_edge">}\href{../../rdecision/html/Graph.html#method-has_edge}{\code{rdecision::Graph$has_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_vertex">}\href{../../rdecision/html/Graph.html#method-has_vertex}{\code{rdecision::Graph$has_vertex()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="is_simple">}\href{../../rdecision/html/Graph.html#method-is_simple}{\code{rdecision::Graph$is_simple()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="neighbours">}\href{../../rdecision/html/Graph.html#method-neighbours}{\code{rdecision::Graph$neighbours()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="order">}\href{../../rdecision/html/Graph.html#method-order}{\code{rdecision::Graph$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="size">}\href{../../rdecision/html/Graph.html#method-size}{\code{rdecision::Graph$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_index">}\href{../../rdecision/html/Graph.html#method-vertex_index}{\code{rdecision::Graph$vertex_index()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Digraph object from sets of nodes and edges.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$new(V, A)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{V}}{A list of Nodes.}

\item{\code{A}}{A list of Arrows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Digraph object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-digraph_adjacency_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-digraph_adjacency_matrix}{}}}
\subsection{Method \code{digraph_adjacency_matrix()}}{
Compute the adjacency matrix for the digraph. Each cell contains the
number of edges from the row vertex to the column vertex, with the 
convention of self loops being counted once, unless 'boolean' is TRUE
when cells are either FALSE (not adjacent) or TRUE (adjacent).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$digraph_adjacency_matrix(boolean = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{boolean}}{If TRUE, the adjacency matrix is logical, each cell is
{FALSE,TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A square numeric matrix with the number of rows and columns
equal to the order of the graph. The rows and columns are in the
same order as V. If the nodes have defined and unique labels the
dimnames of the matrix are the labels of the nodes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-digraph_incidence_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-digraph_incidence_matrix}{}}}
\subsection{Method \code{digraph_incidence_matrix()}}{
Compute the incidence matrix for the graph. Each row is a vertex and
each column is an edge. Edges leaving a vertex have value -1 and edges
entering have value +1. if all vertexes have defined and unique labels
and all edges have defined and unique labels, the dimnames of the matrix
are the labels of the vertexes and edges.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$digraph_incidence_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The incidence matrix.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-topological_sort"></a>}}
\if{latex}{\out{\hypertarget{method-topological_sort}{}}}
\subsection{Method \code{topological_sort()}}{
Attempt to topologically sort the vertexes in the directed graph using
Kahn's algorithm (Kahn, 1962).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$topological_sort()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of vertexes, topologically sorted. If the digraph has
cycles, the returned ordered list will not contain all the vertexes
in the graph, but no error will be raised.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_connected"></a>}}
\if{latex}{\out{\hypertarget{method-is_connected}{}}}
\subsection{Method \code{is_connected()}}{
Test whether the graph is connected. For digraphs this will
always return FALSE because "connected" is not defined. Function
\code{weakly_connected} calculates whether the underlying
graph is connected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_connected()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if connected, FALSE if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_weakly_connected"></a>}}
\if{latex}{\out{\hypertarget{method-is_weakly_connected}{}}}
\subsection{Method \code{is_weakly_connected()}}{
Test whether the digraph is weakly connected, i.e. if the
underlying graph is connected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_weakly_connected()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if connected, FALSE if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_acyclic"></a>}}
\if{latex}{\out{\hypertarget{method-is_acyclic}{}}}
\subsection{Method \code{is_acyclic()}}{
Checks for the presence of a cycle in the graph by attempting to do 
a topological sort. If the sort does not contain all vertexes, the
digraph contains at least one cycle.
This method overrides 'is_acyclic' in Graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_acyclic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if no cycles detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_tree"></a>}}
\if{latex}{\out{\hypertarget{method-is_tree}{}}}
\subsection{Method \code{is_tree()}}{
Compute whether the digraph's underlying graph is a tree (connected and
acyclic).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_tree()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the underlying graph is a tree; FALSE if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_polytree"></a>}}
\if{latex}{\out{\hypertarget{method-is_polytree}{}}}
\subsection{Method \code{is_polytree()}}{
Compute whether the digraph's underlying graph is a tree (connected and
acyclic). Synonymous with 'is_graph'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_polytree()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the underlying graph is a tree; FALSE if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_arborescence"></a>}}
\if{latex}{\out{\hypertarget{method-is_arborescence}{}}}
\subsection{Method \code{is_arborescence()}}{
Check whether the digraph is an arborescence (a tree with a
single root and unique paths from the root).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$is_arborescence()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the digraph is an arborescence; FALSE if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-direct_successors"></a>}}
\if{latex}{\out{\hypertarget{method-direct_successors}{}}}
\subsection{Method \code{direct_successors()}}{
Find the direct successors of a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$direct_successors(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{The index vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of nodes or an empty list if the specified
node has no successors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-direct_predecessors"></a>}}
\if{latex}{\out{\hypertarget{method-direct_predecessors}{}}}
\subsection{Method \code{direct_predecessors()}}{
Find the direct predecessors of a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$direct_predecessors(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{The index vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of nodes or an empty list if the specified
node has no predecessors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-paths"></a>}}
\if{latex}{\out{\hypertarget{method-paths}{}}}
\subsection{Method \code{paths()}}{
Find all directed simple paths from source node \code{s} to target node
\code{t}. In "simple" paths all vertexes are unique.
Uses a recursive depth-first search algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$paths(s, t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{Source node.}

\item{\code{t}}{Target node.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of ordered node lists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-walk"></a>}}
\if{latex}{\out{\hypertarget{method-walk}{}}}
\subsection{Method \code{walk()}}{
Construct the sequence of edges which joins the specified
sequence of vertexes in this graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$walk(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{A list of Nodes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of Edges
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Digraph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
