% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clusterInf.R
\name{vcovCluster}
\alias{vcovCluster}
\alias{vcovCluster2}
\title{Cluster Heteroskedasticity-consistent estimation of the covariance matrix.}
\usage{
vcovCluster(object, clusterVar)

vcovCluster2(object, clusterVar1, clusterVar2)
}
\arguments{
\item{object}{Object of class lm, from which rdd_reg also inherits.}

\item{clusterVar}{The variable containing the cluster attributions.}

\item{clusterVar1,clusterVar2}{The two cluster variables for the 2-cluster case.}
}
\value{
A matrix containing the covariance matrix estimate.
}
\description{
Offer a cluster variant of the usual Heteroskedasticity-consistent
}
\examples{
data(STAR_MHE)
if(all(c(require(sandwich), require(lmtest)))){

# Run simple regression:
reg_krug <- lm(pscore~cs, data=STAR_MHE)

# Row 1 of Table 8.2.1, inference with standard vcovHC:
coeftest(reg_krug,vcov.=vcovHC(reg_krug, 'HC1'))[2,2]

# Row 4 of Table 8.2.1, inference with cluster vcovHC:
coeftest(reg_krug,vcov.=vcovCluster(reg_krug, clusterVar=STAR_MHE$classid))[2,2]
}
}
\author{
Mahmood Arai, see \url{http://people.su.se/~ma/econometrics.html}
}
\references{
Cameron, C.,  Gelbach, J. and Miller, D. (2011) Robust Inference With Multiway Clustering,
\emph{Journal of Business and Economic Statistics},  vol. 29(2), pages 238-249.
#'

Wooldridge (2003) Cluster-sample methods in applied econometrics.
\emph{American Economic Review}, 93, p. 133-138

Arai, M. (2011) Cluster-robust standard errors using R, Note available \url{http://people.su.se/~ma/clustering.pdf}.
}
\seealso{
\code{\link{clusterInf}} for a direct function, allowing also alternative cluster inference methods.
}

