% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_fundref.r
\name{cr_funders}
\alias{cr_funders}
\alias{cr_funders_}
\title{Search the CrossRef Fundref API}
\usage{
cr_funders(dois = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", flq = NULL, select = NULL, ...)

cr_funders_(dois = NULL, query = NULL, filter = NULL,
  offset = NULL, limit = NULL, sample = NULL, sort = NULL,
  order = NULL, facet = FALSE, works = FALSE, cursor = NULL,
  cursor_max = 5000, .progress = "none", parse = FALSE, flq = NULL,
  select = NULL, ...)
}
\arguments{
\item{dois}{Search by a single DOI or many DOIs.}

\item{query}{Query terms}

\item{filter}{Filter options. See examples for usage examples
and \code{\link{filters}} for what filters are available.
\code{filter} is available for use with \code{cr_works} and
other \code{crossref} family functions with \code{works=TRUE}}

\item{offset}{Number of record to start at. Minimum: 1. For
\code{\link{cr_works}}, and any function setting \code{works = TRUE},
the maximum offset value is 10000. For larger requests use \code{cursor}.}

\item{limit}{Number of results to return in the query. Not relavant when
searching with specific dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use
the sample parameter, the rows and offset parameters are ignored.
Ignored unless \code{works=TRUE}. Max: 100}

\item{sort}{Field to sort on. Acceptable set of fields to sort on:
\itemize{
\item \code{score} OR \code{relevance} - Sort by relevance score
\item \code{updated} - Sort by date of most recent change to metadata.
Currently the same as deposited.
\item \code{deposited} - Sort by time of most recent deposit
\item \code{indexed} - Sort by time of most recent index
\item \code{published} - Sort by publication date
\item \code{published-print} - Sort by print publication date
\item \code{published-online} - Sort by online publication date
\item \code{issued} - Sort by issued date (earliest known publication date)
\item \code{is-referenced-by-count} - Sort by number of times this DOI is
referenced by other Crossref DOIs
\item \code{references-count} - Sort by number of references included in
the references section of the document identified by this DOI
}}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results. Boolean or string with
field to facet on. Valid fields are *, affiliation, funder-name,
funder-doi, orcid, container-title, assertion, archive, update-type,
issn, published, source, type-name, publisher-name, license,
category-name, assertion-group. Default: \code{FALSE}}

\item{works}{(logical) If \code{TRUE}, works returned as well, if not then not.}

\item{cursor}{(character) Cursor character string to do deep paging. Default is None.
Pass in '*' to start deep paging. Any combination of query, filters and facets may be
used with deep paging cursors. While rows may be specified along with cursor, offset
and sample cannot be used.
See https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md#deep-paging-with-cursors}

\item{cursor_max}{(integer) Max records to retrieve. Only used when cursor param used.
Because deep paging can result in continuous requests until all are retrieved, use this
parameter to set a maximum number of records. Of course, if there are less records
found than this value, you will get only those found.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text",
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.), or when using the \code{cursor} param. When using the \code{cursor} param,
this argument only accept a boolean, either \code{TRUE} or \code{FALSE}; any
non-boolean is coerced to \code{FALSE}.}

\item{flq}{field queries. One or more field queries. Acceptable set of
field query parameters are:
\itemize{
\item \code{query.title} - Query title and subtitle
\item \code{query.container-title}    - Query container-title aka. publication name
\item \code{query.author} - Query author first and given names
\item \code{query.editor} - Query editor first and given names
\item \code{query.chair}    - Query chair first and given names
\item \code{query.translator} - Query translator first and given names
\item \code{query.contributor} - Query author, editor, chair and translator
first and given names
\item \code{query.bibliographic} - Query bibliographic information, useful for
citation lookup. Includes titles, authors, ISSNs and publication years
\item \code{query.affiliation} - Query contributor affiliations
}}

\item{select}{(character) One or more field to return (only those fields
are returned)}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}

\item{parse}{(logical) Whether to output json \code{FALSE} or parse to
list \code{TRUE}. Default: \code{FALSE}}
}
\description{
Search the CrossRef Fundref API
}
\details{
BEWARE: The API will only work for CrossRef DOIs.

This function name changing to \code{cr_funders} in the next version -
both work for now
}
\note{
See the "Rate limiting" seciton in \link{rcrossref} to get
into the "fast lane"
}
\section{NOTE}{

Funders without IDs don't show up on the /funders route, and in this
function. Some funders don't have assigned IDs in Crossref's system,
so won't show up in searches.
}

\examples{
\dontrun{
cr_funders(query="NSF", limit=1)
cr_funders(query="NSF")
cr_funders(dois='10.13039/100000001')
out <- cr_funders(dois=c('10.13039/100000001','10.13039/100000015'))
out['10.13039/100000001']
out[['10.13039/100000001']]

cr_funders(dois='10.13039/100000001')
cr_funders(dois='10.13039/100000001', works=TRUE, limit=5)

cr_funders(dois=c('10.13039/100000001','10.13039/100000015'))
cr_funders(dois=c('10.13039/100000001','10.13039/100000015'), works=TRUE)

## get facets back
cr_funders("10.13039/100000001", works=TRUE, facet=TRUE, limit = 0)
cr_funders("10.13039/100000001", works=TRUE, facet="license:*", limit = 0)
cr_funders('100000001', works = TRUE, cursor = "*", cursor_max = 500,
   limit = 100, facet=TRUE)

# Curl options
cr_funders(dois='10.13039/100000001', verbose = TRUE)

# If not found, and > 1 DOI given, those not found dropped
cr_funders(dois=c("adfadfaf","asfasf"))
cr_funders(dois=c("adfadfaf","asfasf"), works=TRUE)
cr_funders(dois=c("10.13039/100000001","asfasf"))
cr_funders(dois=c("10.13039/100000001","asfasf"), works=TRUE)

# Use the cursor for deep paging
cr_funders('100000001', works = TRUE, cursor = "*", cursor_max = 500,
   limit = 100)
cr_funders(c('100000001', '100000002'), works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)
## with optional progress bar
cr_funders('100000001', works = TRUE, cursor = "*", cursor_max = 500,
   limit = 100, .progress = TRUE)

# Low level function - does no parsing to data.frame, get json or a list
cr_funders_(query = 'nsf')
cr_funders_('10.13039/100000001')
cr_funders_(query = 'science', parse=TRUE)
cr_funders_('10.13039/100000001', works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)
cr_funders_('10.13039/100000001', works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100, parse = TRUE)

# field queries
## query.container-title
cr_funders('10.13039/100000001', works = TRUE,
  flq = c(`query.container-title` = 'Ecology'))

# select only certain fields to return
res <- cr_funders('10.13039/100000001', works = TRUE, 
  select = c('DOI', 'title'))
names(res$data)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}
\seealso{
Other crossref: \code{\link{cr_journals}},
  \code{\link{cr_licenses}}, \code{\link{cr_members}},
  \code{\link{cr_prefixes}}, \code{\link{cr_types}},
  \code{\link{cr_works}}
}
\concept{crossref}
