% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_prefixes.r
\name{cr_prefixes}
\alias{cr_prefixes}
\alias{cr_prefixes_}
\title{Search CrossRef prefixes}
\usage{
cr_prefixes(prefixes, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", ...)

cr_prefixes_(prefixes, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, works = FALSE, cursor = NULL, cursor_max = 5000,
  .progress = "none", parse = FALSE, ...)
}
\arguments{
\item{prefixes}{(character) Publisher prefixes, one or more in a vector or list. Required.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter, 
the rows and offset parameters are ignored. Ignored unless \code{works=TRUE}}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed, 
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results. Default: \code{FALSE}}

\item{works}{(logical) If TRUE, works returned as well, if not then not.}

\item{cursor}{(character) Cursor character string to do deep paging. Default is None.
Pass in '*' to start deep paging. Any combination of query, filters and facets may be
used with deep paging cursors. While rows may be specified along with cursor, offset
and sample cannot be used.
See https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md#deep-paging-with-cursors}

\item{cursor_max}{(integer) Max records to retrieve. Only used when cursor param used. 
Because deep paging can result in continuous requests until all are retrieved, use this
parameter to set a maximum number of records. Of course, if there are less records
found than this value, you will get only those found.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", 
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details 
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.)}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}

\item{parse}{(logical) Whether to output json \code{FALSE} or parse to
list \code{TRUE}. Default: \code{FALSE}}
}
\description{
Search CrossRef prefixes
}
\details{
BEWARE: The API will only work for CrossRef DOIs.

Note that any one publisher can have more than one DOI. If you want to search on
all DOIs for a publisher, pass in all DOIs, or see \code{\link{cr_members}}, and pass in the
\code{member_ids} parameter.

Notes from CrossRef (quoting them):

The prefix of a CrossRef DOI does NOT indicate who currently owns the DOI. It only
reflects who originally registered the DOI. CrossRef metadata has an \code{owner_prefix}
element that records the current owner of the CrossRef DOI in question.

CrossRef also has member IDs for depositing organisations. A single member may control multiple
owner prefixes, which in turn may control a number of DOIs. When looking at works published by
a certain organisaton, member IDs and the member routes should be used.
}
\examples{
\dontrun{
cr_prefixes(prefixes="10.1016")
cr_prefixes(prefixes="10.1016", works=TRUE)
cr_prefixes(prefixes=c('10.1016','10.1371','10.1023','10.4176','10.1093'))
cr_prefixes(prefixes=c('10.1016','10.1371'), works=TRUE)
cr_works(prefixes="10.1016", filter=c(has_full_text=TRUE), limit=5)
cr_works(prefixes="10.1016", query='ecology', limit=4)
cr_works(prefixes="10.1016", query='ecology', limit=4)

# facets - only avail. when works=TRUE
cr_prefixes(prefixes="10.1016", works=TRUE, facet=TRUE)

## get facets back
cr_prefixes(prefixes="10.1016", works=TRUE, facet=TRUE)
cr_prefixes(prefixes=c('10.1016','10.1371'), works=TRUE, facet=TRUE)

# Use the cursor for deep paging
cr_prefixes("10.1016", works = TRUE, cursor = "*", cursor_max = 500, limit = 100)
cr_prefixes(c('10.1016', '10.1371'), works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)

# Low level function - does no parsing to data.frame, get json or a list
cr_prefixes_("10.1016")
cr_prefixes_(c('10.1016', '10.1371'))
cr_prefixes_("10.1016", works = TRUE, query = 'ecology', limit = 10)
cr_prefixes_("10.1016", works = TRUE, query = 'ecology', parse=TRUE, limit = 10)
cr_prefixes_("10.1016", works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)
cr_prefixes_("10.1016", works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100, parse = TRUE)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

