% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{plot.CMBCorrelation}
\alias{plot.CMBCorrelation}
\title{Plot sample CMBCorrelation}
\usage{
\method{plot}{CMBCorrelation}(x, ...)
}
\arguments{
\item{x}{An object of class CMBCorrelation.}

\item{...}{Extra arguments as in \code{\link{plot.variogram}} passed to plot.default.}
}
\value{
Produces a plot with the sample correlation function.
}
\description{
Plots sample (empirical) correlation function. Uses \code{\link[geoR]{plot.variogram}} from
\strong{geoR} package.
}
\examples{

## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 100000)
# corcmb <- corrCMB(cmbdf, max.dist = 0.03, num.bins = 10, sample.size=1000)
# plot(corcmb)

}
\references{
\strong{geoR} package, \code{\link{corrCMB}}, \code{\link[geoR]{variog}},
\code{\link{plot.variogram}}
}
