% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conversion.R
\name{minDist2nside}
\alias{minDist2nside}
\title{minDist2nside}
\usage{
minDist2nside(dist, factor = 3/4)
}
\arguments{
\item{dist}{The minimum distance between any
two points in a data.frame
of points that lie on S^2}

\item{factor}{Allows changing the shrinkage factor
for the circlular pixels (radius = dist*factor).}
}
\description{
Get an nside such that all points belong
to different pixels, when the minimum
distance between the points is \code{dist}.
}
\details{
We treat pixels as circles. From the total surface
area of a unit sphere and the radius of a circle with
area 4*pi/(12*nside^2), we derive a sufficiently
large nside to achieve the desired separation. We
aim for (circular) pixels with (default)
radius \code{dist}*3/4.
}
\keyword{internal}
