% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_readme_rmd.R
\name{add_readme_rmd}
\alias{add_readme_rmd}
\title{Create a README file}
\usage{
add_readme_rmd(
  type = "package",
  given = NULL,
  family = NULL,
  organisation = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{type}{a character of length 1

If \code{package} (default) a GitHub \code{README.Rmd} specific to an R package will
be created. If \code{compendium} a GitHub \code{README.Rmd} specific to a research
compendium will be created.}

\item{given}{a character of length 1

The given name of the package maintainer.}

\item{family}{a character of length 1

The family name of the package maintainer.}

\item{organisation}{a character of length 1

The name of the GitHub organisation to host the package. If \code{NULL}
(default) the GitHub account will be used. This argument is used to set
the URL of the package (hosted on GitHub).}

\item{open}{a logical value

If \code{TRUE} (default) the file is opened in the editor.}

\item{overwrite}{a logical value

If this file is already present and \code{overwrite = TRUE}, it will be erased
and replaced. Default is \code{FALSE}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function creates a \code{README.Rmd} file at the root of the project based
on a template (adapted from \href{https://usethis.r-lib.org}{\code{usethis}}). Once
edited user needs to knit it into a \code{README.Rmd} (or use the function
\code{\link[=refresh]{refresh()}}).
}
\examples{
\dontrun{
add_readme_rmd(type = "package")
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_compendium}()},
\code{\link{add_description}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
