% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.r
\name{get_best}
\alias{get_best}
\title{Get the best submissions per team.}
\usage{
get_best(history, metrics = names(metrics), test_name = "quiz",
  decreasing = FALSE)
}
\arguments{
\item{history}{list of the submissions history per team as returned by \code{\link{compute_metrics}}}

\item{metrics}{character vector. names of the metrics}

\item{test_name}{string. name of the test set used: \code{"quiz"} or \code{"test"}}

\item{decreasing}{logical. Should the sort order be increasing or decreasing? Must be of length 1 or with 
the same length as \code{metrics}.}
}
\value{
\code{get_best} returns a \code{data.frame} where the rows are teams in sorted order of performance.
  The best submission per team is retained. The sort is based on possibly several metrics in the order 
  given by the \code{metrics} argument. 
  In case of ties on the first metric, the second metric is used to break the ties, and so on. Lastly, 
  the date is used in case of ties. The columns are:
  \item{team}{name of the team}
  \item{n_submissions}{total number of submissions}
  \item{date}{the date of the best submission}
  \item{file}{the file name of the best submission}
  \item{<metric name>.quiz}{the score obtained on the quiz subset}
  \item{<metric name>.test}{the score obtained on the test set}
  \item{rank}{the rank of the team}
  \item{rank_diff}{the rank difference is set to 0 temporarily.}
}
\description{
Get the best submissions per team.
}

