% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/update.r
\name{compute_metrics}
\alias{compute_metrics}
\title{Compute metrics of the submissions in the history.}
\usage{
compute_metrics(hist_dir = "history", metrics, y_test, ind_quiz, read_fun)
}
\arguments{
\item{hist_dir}{string. directory where the history of the submissions are stored.
contains one subdirectory per team.}

\item{metrics}{named list of functions. Each function in the list computes
a performance criterion and is defined as: \code{function(y_pred, y_test)}}

\item{y_test}{character or numeric vector. the test set output.}

\item{ind_quiz}{logical vector with the same length as \code{y_test}. \code{ind_quiz[i]=TRUE}
if \code{y_test[i]} in the quiz subset.}

\item{read_fun}{function that reads a submission file and returns a vector of predictions.}
}
\value{
\code{compute_metrics} returns a named list with one named member per team.
  Each member is a \code{data.frame} where the rows are the submission files sorted by date
  and the columns are:
  \item{date}{the date of the submission}
  \item{file}{the file name of the submission}
  \item{<metric name>.quiz}{the score obtained on the quiz subset}
  \item{<metric name>.test}{the score obtained on the test set}
}
\description{
Compute metrics of the submissions in the history.
}

