% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-yhourarith.R, R/op-cdo-yhouradd.R,
%   R/op-cdo-yhourdiv.R, R/op-cdo-yhourmul.R, R/op-cdo-yhoursub.R
\name{yhourarith}
\alias{yhourarith}
\alias{cdo_yhouradd}
\alias{cdo_yhourdiv}
\alias{cdo_yhourmul}
\alias{cdo_yhoursub}
\title{Multiyear hourly arithmetic}
\usage{
cdo_yhouradd(ifile1, ifile2, ofile = NULL)

cdo_yhourdiv(ifile1, ifile2, ofile = NULL)

cdo_yhourmul(ifile1, ifile2, ofile = NULL)

cdo_yhoursub(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module performs simple arithmetic of a time series and one timestep with the same hour and day of year. For each field in infile1 the corresponding field of the timestep in infile2 with the same hour and day of year is used. The input files need to have the same structure with the same variables. Usually infile2 is generated by an operator of the module YHOURSTAT.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{yhouradd  Add multi-year hourly time series
          Adds a time series and a multi-year hourly time series.
yhoursub  Subtract multi-year hourly time series
          Subtracts a time series and a multi-year hourly time series.
yhourmul  Multiply multi-year hourly time series
          Multiplies a time series and a multi-year hourly time series.
yhourdiv  Divide multi-year hourly time series
          Divides a time series and a multi-year hourly time series.
}\if{html}{\out{</div>}}
}
