% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-vertfillmiss.R, R/op-cdo-vertfillmiss.R
\name{vertfillmiss}
\alias{vertfillmiss}
\alias{cdo_vertfillmiss}
\title{Vertical filling of missing values}
\usage{
cdo_vertfillmiss(
  ifile,
  method = NULL,
  limit = NULL,
  max_gaps = NULL,
  ofile = NULL
)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{method}{STRING - Fill method [nearest|linear|forward|backward] (default: nearest)}

\item{limit}{INTEGER - The maximum number of consecutive missing values to fill (default: all)}

\item{max_gaps}{INTEGER - The maximum number of gaps to fill (default: all)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This operator fills in vertical missing values. The method parameter can be used to select the filling method. The default method=nearest fills missing values with the nearest neighbor value. Other options are forward and backward to fill missing values by forward or backward propagation of values. Use the limit parameter to set the maximum number of consecutive missing values to fill and max_gaps to set the maximum number of gaps to fill.
}
