% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-copy.R, R/op-cdo-cat.R,
%   R/op-cdo-clone.R, R/op-cdo-copy.R
\name{copy}
\alias{copy}
\alias{cdo_cat}
\alias{cdo_clone}
\alias{cdo_copy}
\title{Copy datasets}
\usage{
cdo_cat(ifiles, ofile = NULL)

cdo_clone(ifiles, ofile = NULL)

cdo_copy(ifiles, ofile = NULL)
}
\arguments{
\item{ifiles}{Character vector with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module contains operators to copy, clone or concatenate datasets. infiles is an arbitrary number of input files. All input files need to have the same structure with the same variables on different timesteps.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{copy   Copy datasets
       Copies all input datasets to outfile. 
clone  Clone datasets
       Copies all input datasets to outfile. In contrast to the copy operator, clone tries
       not to change the input data. GRIB records are neither decoded nor decompressed.
cat    Concatenate datasets
       Concatenates all input datasets and appends the result to the end 
       of outfile. If outfile does not exist it will be created.
}\if{html}{\out{</div>}}
}
