% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-compc.R, R/op-cdo-eqc.R, R/op-cdo-gec.R,
%   R/op-cdo-gtc.R, R/op-cdo-lec.R, R/op-cdo-ltc.R, R/op-cdo-nec.R
\name{compc}
\alias{compc}
\alias{cdo_eqc}
\alias{cdo_gec}
\alias{cdo_gtc}
\alias{cdo_lec}
\alias{cdo_ltc}
\alias{cdo_nec}
\title{Comparison of a field with a constant}
\usage{
cdo_eqc(ifile, c = NULL, ofile = NULL)

cdo_gec(ifile, c = NULL, ofile = NULL)

cdo_gtc(ifile, c = NULL, ofile = NULL)

cdo_lec(ifile, c = NULL, ofile = NULL)

cdo_ltc(ifile, c = NULL, ofile = NULL)

cdo_nec(ifile, c = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{c}{FLOAT - Constant}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module compares all fields of a dataset with a constant. The resulting field is a mask containing 1 if the comparison is true and 0 if not. The type of comparison depends on the chosen operator.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{eqc  Equal constant
               /   1   if i(t,x) EQ c     AND  i(t,x),c NE miss
     o(t,x) = &lt;    0   if i(t,x) NE c     AND  i(t,x),c NE miss
               \\\\  miss if i(t,x) EQ miss  OR   c EQ miss
nec  Not equal constant
               /   1   if i(t,x) NE c     AND  i(t,x),c NE miss
     o(t,x) = &lt;    0   if i(t,x) EQ c     AND  i(t,x),c NE miss
               \\\\  miss if i(t,x) EQ miss  OR   c EQ miss
lec  Less equal constant
               /   1   if i(t,x) LE c     AND  i(t,x),c NE miss
     o(t,x) = &lt;    0   if i(t,x) GT c     AND  i(t,x),c NE miss
               \\\\  miss if i(t,x) EQ miss  OR   c EQ miss
ltc  Less than constant
               /   1   if i(t,x) LT c     AND  i(t,x),c NE miss
     o(t,x) = &lt;    0   if i(t,x) GE c     AND  i(t,x),c NE miss
               \\\\  miss if i(t,x) EQ miss  OR   c EQ miss
gec  Greater equal constant
               /   1   if i(t,x) GE c     AND  i(t,x),c NE miss
     o(t,x) = &lt;    0   if i(t,x) LT c     AND  i(t,x),c NE miss
               \\\\  miss if i(t,x) EQ miss  OR   c EQ miss
gtc  Greater than constant
               /   1   if i(t,x) GT c     AND  i(t,x),c NE miss
     o(t,x) = &lt;    0   if i(t,x) LE c     AND  i(t,x),c NE miss
               \\\\  miss if i(t,x) EQ miss  OR   c EQ miss
}\if{html}{\out{</div>}}
}
