/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.atomtypes;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.config.atomtypes.AtomTypeHandler;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AtomTypeReader {
    private XMLReader parser;
    private Reader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomTypeReader.class);

    public AtomTypeReader(Reader input) {
        this.init();
        this.input = input;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (ParserConfigurationException | SAXException exception) {
                logger.warn("Could not instantiate JAXP/SAX XML reader!");
                logger.debug(exception);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                logger.warn("Could not instantiate Aelfred2 XML reader!");
                logger.debug(exception);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                logger.warn("Could not instantiate Xerces XML reader!");
                logger.debug(exception);
            }
        }
        if (!success) {
            logger.error("Could not instantiate any XML parser!");
        }
    }

    public List<IAtomType> readAtomTypes(IChemObjectBuilder builder) {
        ArrayList<IAtomType> isotopes = new ArrayList();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info("Deactivated validation");
        }
        catch (SAXException exception) {
            logger.warn("Cannot deactivate validation: ", exception.getMessage());
            logger.debug(exception);
        }
        AtomTypeHandler handler = new AtomTypeHandler(builder);
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            isotopes = handler.getAtomTypes();
        }
        catch (IOException exception) {
            logger.error("IOException: ", exception.getMessage());
            logger.debug(exception);
        }
        catch (SAXException saxe) {
            logger.error("SAXException: ", saxe.getMessage());
            logger.debug(saxe);
        }
        return isotopes;
    }
}

