/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class RadicalSiteHrGammaReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RadicalSiteHrGammaReaction.class);

    @Override
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#RadicalSiteHrGamma", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: RadicalSiteHrGammaReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("RadicalSiteHrGammaReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("RadicalSiteHrGammaReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactant);
        Aromaticity.cdkLegacy().apply(reactant);
        AllRingsFinder arf = new AllRingsFinder();
        IRingSet ringSet = arf.findAllRings(reactant);
        for (int ir = 0; ir < ringSet.getAtomContainerCount(); ++ir) {
            IRing ring = (IRing)ringSet.getAtomContainer(ir);
            for (int jr = 0; jr < ring.getAtomCount(); ++jr) {
                IAtom aring = ring.getAtom(jr);
                aring.setFlag(2, true);
            }
        }
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        HOSECodeGenerator hcg = new HOSECodeGenerator();
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(1024) || !atomi.getSymbol().equals("C") || reactant.getConnectedSingleElectronsCount(atomi) != 1) continue;
            hcg.getSpheres(reactant, atomi, 4, true);
            for (IAtom atoml : hcg.getNodesInSphere(4)) {
                if (atoml == null || !atoml.getFlag(1024) || atoml.getFlag(2) || (atoml.getFormalCharge() == CDKConstants.UNSET ? 0 : atoml.getFormalCharge()) != 0 || atoml.getSymbol().equals("H") || reactant.getMaximumBondOrder(atoml) != IBond.Order.SINGLE) continue;
                for (IAtom atomh : reactant.getConnectedAtomsList(atoml)) {
                    if (!reactant.getBond(atomh, atoml).getFlag(1024) || !atomh.getFlag(1024) || !atomh.getSymbol().equals("H")) continue;
                    ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                    atomList.add(atomh);
                    atomList.add(atomi);
                    atomList.add(atoml);
                    ArrayList<IBond> bondList = new ArrayList<IBond>();
                    bondList.add(reactant.getBond(atomh, atoml));
                    IAtomContainerSet moleculeSet = reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    moleculeSet.addAtomContainer(reactant);
                    IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                    if (reaction == null) continue;
                    setOfReactions.addReaction(reaction);
                }
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        HOSECodeGenerator hcg = new HOSECodeGenerator();
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getSymbol().equals("C") || reactant.getConnectedSingleElectronsCount(atomi) != 1) continue;
            hcg.getSpheres(reactant, atomi, 4, true);
            for (IAtom atoml : hcg.getNodesInSphere(4)) {
                if (atoml == null || atoml.getFlag(2) || (atoml.getFormalCharge() == CDKConstants.UNSET ? 0 : atoml.getFormalCharge()) != 0 || atoml.getSymbol().equals("H") || reactant.getMaximumBondOrder(atoml) != IBond.Order.SINGLE) continue;
                for (IAtom atomh : reactant.getConnectedAtomsList(atoml)) {
                    if (!atomh.getSymbol().equals("H")) continue;
                    atomi.setFlag(1024, true);
                    atoml.setFlag(1024, true);
                    atomh.setFlag(1024, true);
                    reactant.getBond(atomh, atoml).setFlag(1024, true);
                }
            }
        }
    }
}

