/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.formula.RangeMassDecomposer;
import org.openscience.cdk.interfaces.IIsotope;

final class DecomposerFactory {
    private static final int maximalNumberOfCachedDecomposers = 10;
    private static final DecomposerFactory instance = new DecomposerFactory();
    private final List<RangeMassDecomposer> decomposerCache = new ArrayList<RangeMassDecomposer>(10);

    private DecomposerFactory() {
    }

    public static DecomposerFactory getInstance() {
        return instance;
    }

    public RangeMassDecomposer getDecomposerFor(IIsotope[] alphabet) {
        for (RangeMassDecomposer decomposer : this.decomposerCache) {
            if (!decomposer.isCompatible(alphabet)) continue;
            return decomposer;
        }
        if (this.decomposerCache.size() >= 10) {
            this.decomposerCache.remove(0);
        }
        RangeMassDecomposer decomposer = new RangeMassDecomposer(alphabet);
        this.decomposerCache.add(decomposer);
        return decomposer;
    }
}

