/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BasicFBReifier;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.reasoner.rulesys.impl.SafeGraph;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicForwardRuleInfGraph
extends BaseInfGraph
implements ForwardRuleInfGraphI {
    protected OneToManyMap<Triple, Derivation> derivations;
    protected FGraph fdeductions;
    protected Graph safeDeductions;
    protected Graph schemaGraph;
    protected FRuleEngineI engine;
    private List<Rule> rules;
    public boolean filterFunctors = true;
    protected boolean traceOn = false;
    private static Logger logger = LoggerFactory.getLogger(BasicForwardRuleInfGraph.class);

    public BasicForwardRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(null, reasoner);
        this.instantiateRuleEngine(null);
        this.schemaGraph = schema;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema) {
        this(reasoner, rules, schema, ReificationStyle.Minimal);
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema, ReificationStyle style) {
        super(null, reasoner, style);
        this.instantiateRuleEngine(rules);
        this.rules = rules;
        this.schemaGraph = schema;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema, Graph data) {
        this(reasoner, rules, schema);
        this.rebind(data);
    }

    protected void instantiateRuleEngine(List<Rule> rules) {
        this.engine = rules != null ? new FRuleEngine(this, rules) : new FRuleEngine(this);
    }

    public void setRuleStore(Object ruleStore) {
        this.engine.setRuleStore(ruleStore);
    }

    @Override
    public void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.rebind();
    }

    @Override
    public void rebind() {
        ++this.version;
        this.isPrepared = false;
    }

    @Override
    public Graph getSchemaGraph() {
        return this.schemaGraph;
    }

    @Override
    public synchronized void prepare() {
        if (this.isPrepared) {
            return;
        }
        this.isPrepared = true;
        this.fdeductions = new FGraph(this.createDeductionsGraph());
        boolean rulesLoaded = false;
        if (this.schemaGraph != null) {
            rulesLoaded = this.preloadDeductions(this.schemaGraph);
        }
        if (rulesLoaded) {
            this.engine.fastInit(this.fdata);
        } else {
            this.engine.init(true, this.fdata);
        }
    }

    protected boolean preloadDeductions(Graph preloadIn) {
        Graph d = this.fdeductions.getGraph();
        BasicForwardRuleInfGraph preload = (BasicForwardRuleInfGraph)preloadIn;
        if (preload.rules == this.rules) {
            ExtendedIterator<Triple> i = preload.find(null, null, null);
            while (i.hasNext()) {
                d.add((Triple)i.next());
            }
            this.engine.setRuleStore(preload.engine.getRuleStore());
            return true;
        }
        return false;
    }

    @Override
    public void addDeduction(Triple t) {
        this.getDeductionsGraph().add(t);
    }

    @Override
    public void setFunctorFiltering(boolean param) {
        this.filterFunctors = param;
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        return this.findWithContinuation(pattern, continuation, true);
    }

    private ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation, boolean filter) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator<Triple> result = null;
        result = this.fdata == null ? this.fdeductions.findWithContinuation(pattern, continuation) : (continuation == null ? this.fdata.findWithContinuation(pattern, this.fdeductions) : this.fdata.findWithContinuation(pattern, FinderUtil.cascade(this.fdeductions, continuation)));
        if (filter && this.filterFunctors) {
            return result.filterDrop(Functor.acceptFilter);
        }
        return result;
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    @Override
    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.fdata.getGraph().add(t);
        if (this.isPrepared) {
            this.engine.add(t);
        }
    }

    @Override
    public int graphBaseSize() {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        int baseSize = this.fdata.getGraph().size();
        int dedSize = this.fdeductions.getGraph().size();
        return baseSize + dedSize;
    }

    @Override
    public void performDelete(Triple t) {
        Graph data;
        ++this.version;
        if (this.fdata != null && (data = this.fdata.getGraph()) != null) {
            data.delete(t);
        }
        if (this.isPrepared) {
            this.fdeductions.getGraph().delete(t);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.engine = null;
            this.fdeductions = null;
            this.rules = null;
            this.schemaGraph = null;
            super.close();
        }
    }

    @Override
    public void addBRule(Rule brule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + brule.toShortString());
    }

    @Override
    public void deleteBRule(Rule brule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + brule.toShortString());
    }

    @Override
    public Graph getDeductionsGraph() {
        this.prepare();
        return this.safeDeductions;
    }

    protected Graph createDeductionsGraph() {
        Graph dg;
        if (this.fdeductions != null && (dg = this.fdeductions.getGraph()) != null) {
            this.safeDeductions.getBulkUpdateHandler().removeAll();
            return dg;
        }
        dg = Factory.createGraphMem(this.style);
        this.safeDeductions = new SafeGraph(dg);
        return dg;
    }

    @Override
    public Graph getCurrentDeductionsGraph() {
        return this.safeDeductions;
    }

    @Override
    public ExtendedIterator<Triple> findDataMatches(Node subject, Node predicate, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, predicate, object), null, false);
    }

    @Override
    public void logDerivation(Triple t, Derivation derivation) {
        this.derivations.put(t, derivation);
    }

    @Override
    public void silentAdd(Triple t) {
        this.fdeductions.getGraph().add(t);
    }

    @Override
    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    @Override
    public boolean shouldLogDerivations() {
        return this.recordDerivations;
    }

    @Override
    public Iterator<Derivation> getDerivation(Triple t) {
        if (this.derivations == null) {
            return new NullIterator<Derivation>();
        }
        return this.derivations.getAll(t);
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    @Override
    public boolean shouldTrace() {
        return this.traceOn && this.engine.shouldTrace();
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    @Override
    public Reifier constructReifier() {
        BasicFBReifier.GetReifier deductionsReifier = new BasicFBReifier.GetReifier(){

            @Override
            public Reifier getReifier() {
                return BasicForwardRuleInfGraph.this.getDeductionsGraph().getReifier();
            }
        };
        return new BasicFBReifier(this, this.getRawGraph().getReifier(), deductionsReifier, this.style);
    }
}

