/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractAtomSet;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLLink;
import org.xmlcml.cml.element.CMLMap;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Point3Vector;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real3Range;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;
import org.xmlcml.molutil.ChemicalElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLAtomSet
extends AbstractAtomSet {
    static final Logger logger = Logger.getLogger(CMLAtomSet.class);
    public static final String NS = "cml:atomSet";
    public static final int MAX_DIST = 999999;
    protected CMLMolecule molecule;
    protected LinkedHashSet<CMLAtom> set = new LinkedHashSet();
    protected Map<String, CMLAtom> idTable;
    protected boolean checkDuplicates = false;

    public CMLAtomSet() {
        this.checkDuplicates = true;
    }

    private void init() {
        this.set = new LinkedHashSet();
        this.idTable = new HashMap<String, CMLAtom>();
        this.setXMLContent("");
        this.setSize(0);
    }

    public CMLAtomSet(CMLAtomSet old) {
        super(old);
        this.init();
        for (CMLAtom atom : old.set) {
            this.addAtom(atom);
        }
    }

    @Override
    public Node copy() {
        return new CMLAtomSet(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLAtomSet();
    }

    public CMLAtomSet(CMLMolecule mol, String[] atomId) {
        this();
        for (int i = 0; i < atomId.length; ++i) {
            CMLAtom atom = mol.getAtomById(atomId[i]);
            if (atom == null) continue;
            this.addAtom(atom);
        }
    }

    public static CMLAtomSet createFromMolecules(List<CMLMolecule> molecules) {
        CMLAtomSet atomSet = new CMLAtomSet();
        for (CMLMolecule mol : molecules) {
            atomSet.addAtoms(mol.getAtoms());
            atomSet.molecule = null;
        }
        return atomSet;
    }

    public static CMLAtomSet createFromAtoms(List<CMLAtom> atoms) {
        CMLAtomSet atomSet = new CMLAtomSet();
        atomSet.addAtoms(atoms);
        return atomSet;
    }

    public CMLAtomSet(CMLMolecule mol) {
        this.checkDuplicates = false;
        List<CMLAtom> atomList = mol.getAtoms();
        this.addAtoms(atomList);
    }

    public CMLAtomSet(List<CMLMolecule> molecules) {
        this();
        for (CMLMolecule molecule : molecules) {
            this.addAtoms(molecule.getAtoms());
        }
    }

    public CMLAtomSet(CMLAtom[] atoms) {
        this();
        this.addAtoms(atoms);
    }

    public CMLAtomSet(Set<CMLAtom> atomSet) {
        this();
        if (atomSet != null) {
            for (CMLAtom atom : atomSet) {
                this.addAtom(atom);
            }
        }
    }

    public void addAtoms(CMLAtom[] atoms) {
        if (atoms != null) {
            for (int i = 0; i < atoms.length; ++i) {
                this.addAtom(atoms[i]);
            }
        }
    }

    public void addAtoms(List<CMLAtom> atoms) {
        boolean forceUpdate = false;
        String[] ids = new String[atoms.size()];
        int i = 0;
        for (CMLAtom atom : atoms) {
            this.addAtom(atom, forceUpdate);
            ids[i++] = atom.getId();
        }
        this.updateContent();
    }

    public void updateContent() {
        String[] ids = this.getAtomIDs();
        this.setXMLContent(ids);
        this.setSize(ids.length);
    }

    public void addAtom(CMLAtom atom) {
        boolean forceUpdate = true;
        this.addAtom(atom, forceUpdate);
    }

    public void addAtom(CMLAtom atom, boolean forceUpdate) {
        if (atom != null && !this.set.contains(atom)) {
            this.set.add(atom);
            if (this.idTable == null) {
                this.idTable = new HashMap<String, CMLAtom>();
            }
            this.idTable.put(atom.getId(), atom);
            if (forceUpdate) {
                this.addAtomId(atom.getId());
            }
        }
        if (this.molecule == null) {
            this.molecule = atom.getMolecule();
        } else if (this.checkDuplicates && !this.molecule.equals(atom.getMolecule()) && atom.getMolecule() != null) {
            System.out.println(this.molecule.hashCode() + "/" + atom.getMolecule().hashCode());
            throw new RuntimeException("cannot add atoms from different moelcules");
        }
    }

    private void addAtomId(String id) {
        String[] content = new String[]{};
        int size = 0;
        if (this.getSizeAttribute() != null) {
            content = this.getXMLContent();
            size = this.getSize();
        }
        this.setXMLContent(Util.addElementToStringArray((String[])content, (String)id));
        this.setSize(size + 1);
    }

    public void addAtomSet(CMLAtomSet atomSet) {
        this.addAtoms(atomSet.getAtoms());
    }

    public CMLAtom getAtom(int i) {
        List<CMLAtom> atomList = this.getAtoms();
        return atomList == null || i < 0 || i >= atomList.size() ? null : atomList.get(i);
    }

    public List<CMLAtom> getAtoms() {
        ArrayList<CMLAtom> atoms = new ArrayList<CMLAtom>();
        Iterator e = this.set.iterator();
        while (e.hasNext()) {
            atoms.add((CMLAtom)e.next());
        }
        return atoms;
    }

    public int size() {
        return this.set.size();
    }

    public String[] getAtomIDs() {
        String[] atomIDs = new String[this.set.size()];
        int count = 0;
        Iterator ii = this.set.iterator();
        while (ii.hasNext()) {
            atomIDs[count++] = ((CMLAtom)ii.next()).getId();
        }
        return atomIDs;
    }

    public CMLAtomSet getAtomSetById(List<String> ids) {
        CMLAtomSet atomSet = new CMLAtomSet();
        for (String id : ids) {
            CMLAtom atom = this.getAtomById(id);
            atomSet.addAtom(atom);
        }
        return atomSet;
    }

    public CMLAtomSet getAtomSetById(String[] ids) {
        CMLAtomSet atomSet = new CMLAtomSet();
        for (String id : ids) {
            CMLAtom atom = this.getAtomById(id);
            if (atom == null) {
                throw new RuntimeException("unknown atom: " + id);
            }
            atomSet.addAtom(atom);
        }
        return atomSet;
    }

    public CMLAtomSet getAtomSetByElementType(String elementType) {
        CMLAtomSet atomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            if (!elementType.equals(atom.getElementType())) continue;
            atomSet.addAtom(atom);
        }
        return atomSet;
    }

    public CMLAtom getAtomById(String id) {
        return this.idTable == null ? null : this.idTable.get(id);
    }

    public boolean contains(CMLAtom atom) {
        return this.set.contains(atom);
    }

    public void removeAtom(CMLAtom atom) throws RuntimeException {
        if (atom != null && this.set.contains(atom)) {
            this.set.remove(atom);
            String id = atom.getId();
            this.idTable.remove(id);
            String[] content = this.getXMLContent();
            content = Util.removeElementFromStringArray((String[])content, (String)id);
            this.setXMLContent(content);
            int c = this.getSize();
            this.setSize(c - 1);
        }
    }

    public void removeAtomById(String id) throws RuntimeException {
        this.removeAtom(this.getAtomById(id));
    }

    public void removeAtomSet(CMLAtomSet atomSet) throws RuntimeException {
        if (atomSet != null) {
            for (CMLAtom atom : atomSet.getAtoms()) {
                if (!this.contains(atom)) continue;
                this.removeAtom(atom);
            }
        }
    }

    public Point3Vector getCoordinates3(CMLElement.CoordinateType type) {
        List<CMLAtom> atoms = this.getAtoms();
        Point3Vector p3Vector = new Point3Vector();
        boolean ok = true;
        for (CMLAtom atom : atoms) {
            if (!atom.hasCoordinates(type)) {
                ok = false;
                break;
            }
            p3Vector.add(atom.getPoint3(type));
        }
        return !ok ? null : p3Vector;
    }

    public void translate3D(Vector3 delta3) {
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            if (atom.getX3Attribute() == null || atom.getY3Attribute() == null || atom.getZ3Attribute() == null) continue;
            atom.setX3(atom.getX3() + delta3.getArray()[0]);
            atom.setY3(atom.getY3() + delta3.getArray()[1]);
            atom.setZ3(atom.getZ3() + delta3.getArray()[2]);
        }
    }

    public Point3 getCentroid3(CMLElement.CoordinateType type) {
        Point3 centroid3 = null;
        Point3Vector p3Vector = this.getCoordinates3(type);
        if (p3Vector != null) {
            centroid3 = p3Vector.getCentroid();
        }
        return centroid3;
    }

    public Real3Range calculateRange3(CMLElement.CoordinateType type) {
        Real3Range range3 = null;
        Point3Vector p3Vector = this.getCoordinates3(type);
        if (p3Vector != null) {
            range3 = p3Vector.getRange3();
        }
        return range3;
    }

    public CMLMolecule getMolecule() {
        if (this.molecule == null) {
            List<CMLAtom> atoms = this.getAtoms();
            if (atoms.size() > 0) {
                this.molecule = CMLMolecule.getMoleculeAncestor(atoms.get(0));
            } else {
                throw new RuntimeException("NO atoms in set...");
            }
        }
        return this.molecule;
    }

    public CMLAtomSet excludeElementTypes(String[] elementTypes) {
        CMLAtomSet newAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            String elementType = atom.getElementType();
            boolean exclude = false;
            for (int j = 0; j < elementTypes.length; ++j) {
                if (elementType != null && !elementType.equals("") && !elementType.equals(elementTypes[j])) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            newAtomSet.addAtom(atoms.get(i));
        }
        return newAtomSet;
    }

    @Override
    public int compareTo(CMLAtomSet otherAtomSet) {
        int result = 0;
        if (otherAtomSet == null) {
            result = 1;
        } else {
            List<CMLAtom> atoms = this.getAtoms();
            List<CMLAtom> otherAtoms = otherAtomSet.getAtoms();
            int length = Math.min(atoms.size(), otherAtoms.size());
            for (int i = 0; i < length; ++i) {
                int compare = atoms.get(i).compareTo(otherAtoms.get(i));
                if (compare == 0) continue;
                result = compare;
                break;
            }
            if (atoms.size() > length) {
                result = 1;
            } else if (otherAtoms.size() > length) {
                result = -1;
            }
        }
        return result;
    }

    public boolean hasContentEqualTo(CMLAtomSet otherAtomSet) {
        boolean result = false;
        if (otherAtomSet != null && this.size() == otherAtomSet.size()) {
            CMLAtomSet atomSet = this.complement(otherAtomSet);
            result = atomSet.size() == 0;
        }
        return result;
    }

    public CMLAtomSet includeElementTypes(String[] elementTypes) {
        CMLAtomSet newAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            String elementType = atom.getElementType();
            boolean include = false;
            for (int j = 0; j < elementTypes.length; ++j) {
                if (!elementType.equals(elementTypes[j])) continue;
                include = true;
                break;
            }
            if (!include) continue;
            newAtomSet.addAtom(atom);
        }
        return newAtomSet;
    }

    public CMLFormula getCalculatedFormula(CMLMolecule.HydrogenControl control) throws RuntimeException {
        CMLFormula formula = new CMLFormula();
        if (!(control.equals((Object)CMLMolecule.HydrogenControl.USE_HYDROGEN_COUNT) || control.equals((Object)CMLMolecule.HydrogenControl.USE_EXPLICIT_HYDROGENS) || control.equals((Object)CMLMolecule.HydrogenControl.NO_EXPLICIT_HYDROGENS))) {
            throw new RuntimeException("No hydrogen count control on Formula");
        }
        double hCount = 0.0;
        for (CMLAtom atom : this.getAtoms()) {
            int multiplicity;
            String elementType = atom.getElementType();
            double occupancy = atom.getOccupancyAttribute() == null ? 1.0 : atom.getOccupancy();
            int n = multiplicity = atom.getSpaceGroupMultiplicityAttribute() == null ? 1 : atom.getSpaceGroupMultiplicity();
            if (ChemicalElement.AS.H.equals(elementType)) {
                if (!CMLMolecule.HydrogenControl.USE_EXPLICIT_HYDROGENS.equals((Object)control)) continue;
                hCount += occupancy / (double)multiplicity;
                continue;
            }
            if (CMLMolecule.HydrogenControl.USE_HYDROGEN_COUNT.equals((Object)control)) {
                hCount += (double)atom.getHydrogenCount() * occupancy;
            }
            formula.add(elementType, occupancy / (double)multiplicity);
        }
        if (hCount > 1.0E-6) {
            formula.add(ChemicalElement.AS.H.value, hCount);
        }
        int charge = this.getCalculatedFormalCharge();
        formula.setFormalCharge(charge);
        formula.normalize();
        return formula;
    }

    public int getCalculatedFormalCharge() throws RuntimeException {
        List<CMLAtom> atoms = this.getAtoms();
        int charge = 0;
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            try {
                charge += atom.getFormalCharge();
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return charge;
    }

    public CMLAtomSet intersection(CMLAtomSet atomSet2) throws RuntimeException {
        CMLAtomSet newAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            if (!atomSet2.contains(atoms.get(i))) continue;
            newAtomSet.addAtom(atoms.get(i));
        }
        return newAtomSet;
    }

    public CMLAtomSet complement(CMLAtomSet atomSet2) {
        if (atomSet2 == null) {
            return this;
        }
        CMLAtomSet newAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            if (atomSet2.contains(atoms.get(i))) continue;
            newAtomSet.addAtom(atoms.get(i));
        }
        return newAtomSet;
    }

    public CMLAtomSet union(CMLAtomSet atomSet2) throws RuntimeException {
        CMLAtomSet newAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        newAtomSet.addAtoms(atoms);
        newAtomSet.addAtoms(atomSet2.getAtoms());
        return newAtomSet;
    }

    public CMLAtomSet symmetricDifference(CMLAtomSet atomSet2) {
        CMLAtomSet newAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            if (atomSet2.contains(atoms.get(i))) continue;
            newAtomSet.addAtom(atoms.get(i));
        }
        List<CMLAtom> atoms2 = atomSet2.getAtoms();
        for (int i = 0; i < atoms2.size(); ++i) {
            CMLAtom atom = atoms2.get(i);
            if (this.contains(atom)) continue;
            newAtomSet.addAtom(atom);
        }
        return newAtomSet;
    }

    public String[] intersectionByAtomId(CMLAtomSet atomSet2) {
        CMLAtomSet result = this.intersection(atomSet2);
        return result.getAtomIDs();
    }

    public String[] complementByAtomId(CMLAtomSet atomSet2) {
        CMLAtomSet result = this.complement(atomSet2);
        return result.getAtomIDs();
    }

    public String[] unionByAtomId(CMLAtomSet atomSet2) {
        CMLAtomSet result = this.union(atomSet2);
        return result.getAtomIDs();
    }

    public String[] symmetricDifferenceByAtomId(CMLAtomSet atomSet2) {
        CMLAtomSet result = this.symmetricDifference(atomSet2);
        return result.getAtomIDs();
    }

    public void transform(Transform2 transform) {
        List<CMLAtom> atoms = this.getAtoms();
        for (CMLAtom atom : atoms) {
            atom.transform(transform);
        }
    }

    public List<Real2> getVector2D() {
        List<CMLAtom> atoms = this.getAtoms();
        ArrayList<Real2> p2Vector = new ArrayList<Real2>();
        boolean ok = true;
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            if (atom.getX2Attribute() == null || atom.getY2Attribute() == null) {
                ok = false;
                break;
            }
            Real2 p2 = new Real2(atom.getX2(), atom.getY2());
            p2Vector.add(p2);
        }
        if (!ok) {
            p2Vector = null;
        }
        return p2Vector;
    }

    public void setVector2D(List<Real2> p2Vector) {
        List<CMLAtom> atoms = this.getAtoms();
        if (p2Vector.size() != atoms.size()) {
            throw new RuntimeException("Vector (" + p2Vector.size() + ") not same length as atoms (" + atoms.size() + ")");
        }
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            Real2 coord = p2Vector.get(i);
            atom.setX2(coord.getX());
            atom.setY2(coord.getY());
        }
    }

    public void translate2D(Real2 delta2) {
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            if (atom.getX2Attribute() == null || atom.getY2Attribute() == null) continue;
            atom.setX2(atom.getX2() + delta2.getX());
            atom.setY2(atom.getY2() + delta2.getY());
        }
    }

    public void scale2D(double scale) {
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            Real2 xy = atom.getXY2();
            if (xy == null) continue;
            xy = new Real2(xy.multiplyBy(scale));
            atom.setXY2(xy);
        }
    }

    public Real2 getCentroid2D() {
        Real2 centroid2D = null;
        List<Real2> p2Vector = this.getVector2D();
        if (p2Vector != null) {
            centroid2D = Real2.getCentroid(p2Vector);
        }
        return centroid2D;
    }

    public Real2 overlap2DCentroids(CMLAtomSet atomSet2) {
        Real2 centroid = this.getCentroid2D();
        Real2 centroid2 = atomSet2.getCentroid2D();
        Real2 shift = centroid.subtract(centroid2);
        atomSet2.translate2D(shift);
        centroid2 = atomSet2.getCentroid2D();
        return shift;
    }

    public RealMatrix getDistanceMatrix(CMLAtomSet atomSet2) {
        List<Real2> coords = this.getVector2D();
        List<Real2> coords2 = atomSet2.getVector2D();
        RealMatrix matrix = null;
        if (coords != null && coords2 != null) {
            matrix = Real2.getDistanceMatrix(coords, coords2);
        }
        return matrix;
    }

    public void setChemicalElements(String elementType) {
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            atom.setElementType(elementType);
        }
    }

    public void labelAtoms(String labelValue) {
        List<CMLAtom> atoms = this.getAtoms();
        if (atoms.size() > 0) {
            for (int i = 0; i < atoms.size(); ++i) {
                CMLAtom atom = atoms.get(i);
                CMLLabel label = new CMLLabel();
                label.setCMLValue(labelValue);
                atom.addLabel(label);
            }
        }
    }

    public CMLMap getMap(CMLAtomSet atomSet2) {
        CMLMap map = null;
        List<CMLAtom> fromAtoms = this.getAtoms();
        List<CMLAtom> toAtoms = atomSet2.getAtoms();
        if (atomSet2 != null) {
            toAtoms = atomSet2.getAtoms();
        }
        if (toAtoms != null && toAtoms.size() == fromAtoms.size()) {
            map = new CMLMap();
            for (int i = 0; i < fromAtoms.size(); ++i) {
                CMLLink link = new CMLLink();
                link.setTitle("from getMap");
                link.setFrom(fromAtoms.get(i).getId());
                link.setTo(toAtoms.get(i).getId());
                map.addLink(link);
            }
        }
        return map;
    }

    public Map<String, CMLAtomSet> splitByElements() {
        HashMap<String, CMLAtomSet> map = new HashMap<String, CMLAtomSet>();
        List<CMLAtom> atoms = this.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            CMLAtom atom = atoms.get(i);
            String el = atom.getElementType();
            CMLAtomSet atomSet = (CMLAtomSet)map.get(el);
            if (atomSet == null) {
                atomSet = new CMLAtomSet();
                map.put(el, atomSet);
            }
            atomSet.addAtom(atom);
        }
        return map;
    }

    public CMLAtom getMappedAtom(CMLMap map, CMLAtom atom0, CMLMap.Direction toFrom) {
        String targetId;
        CMLAtom targetAtom = null;
        String string = targetId = atom0 == null || map == null ? null : map.getRef(atom0.getId(), toFrom);
        if (targetId != null) {
            targetAtom = this.getAtomById(targetId);
        }
        return targetAtom;
    }

    public CMLAtomSet getMappedAtomSet(CMLMap map, CMLAtomSet atomSet1, CMLMap.Direction toFrom) {
        CMLAtomSet targetAtomSet = new CMLAtomSet();
        List<CMLAtom> atoms1 = this.getAtoms();
        for (CMLAtom atom0 : atoms1) {
            CMLAtom targetAtom = null;
            String targetId = atom0 == null ? null : map.getRef(atom0.getId(), toFrom);
            if (targetId == null) continue;
            targetAtom = atomSet1.getAtomById(targetId);
            targetAtomSet.addAtom(targetAtom);
        }
        return targetAtomSet;
    }

    public void removeAtoms(CMLMap map, CMLAtomSet toAtomSet) {
        this.removeAtoms(map, CMLMap.Direction.FROM);
        toAtomSet.removeAtoms(map, CMLMap.Direction.TO);
    }

    public void removeAtoms(CMLMap map, CMLMap.Direction control) {
        for (String ref : map.getRefs(control)) {
            this.removeAtomById(ref);
        }
    }

    public void setMolecule(CMLMolecule molecule) {
        this.molecule = molecule;
    }
}

