/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSBond;

public class LogicalOperatorBond
extends SMARTSBond {
    private static final long serialVersionUID = 7508020488830371461L;
    private IQueryBond left;
    private String operator;
    private IQueryBond right;

    public LogicalOperatorBond(IChemObjectBuilder builder) {
        super(builder);
    }

    public IQueryBond getLeft() {
        return this.left;
    }

    public String getOperator() {
        return this.operator;
    }

    public IQueryBond getRight() {
        return this.right;
    }

    public void setLeft(IQueryBond left) {
        this.left = left;
    }

    public void setOperator(String name) {
        this.operator = name;
    }

    public void setRight(IQueryBond right) {
        this.right = right;
    }

    @Override
    public boolean matches(IBond bond) {
        boolean matchesLeft = this.left.matches(bond);
        if (this.right != null) {
            boolean matchesRight = this.right.matches(bond);
            if ("and".equals(this.operator)) {
                return matchesLeft && matchesRight;
            }
            if ("or".equals(this.operator)) {
                return matchesLeft || matchesRight;
            }
            return false;
        }
        if ("not".equals(this.operator)) {
            return !matchesLeft;
        }
        return matchesLeft;
    }

    public void setAtoms(IAtom[] atoms) {
        super.setAtoms(atoms);
        this.left.setAtoms(atoms);
        if (this.right != null) {
            this.right.setAtoms(atoms);
        }
    }
}

