/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.ZMatrixTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.ZMatrixFormat;

@TestClass(value="org.openscience.cdk.io.ZMatrixReaderTest")
public class ZMatrixReader
extends DefaultChemObjectReader {
    private BufferedReader input;

    public ZMatrixReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public ZMatrixReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public ZMatrixReader() {
        this(new StringReader(""));
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return ZMatrixFormat.getInstance();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        return IChemFile.class.isAssignableFrom(classObject);
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only ChemFile objects can be read.");
    }

    private IChemFile readChemFile(IChemFile file) {
        IChemSequence chemSequence = (IChemSequence)file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        try {
            String line = this.input.readLine();
            while (line.startsWith("#")) {
                line = this.input.readLine();
            }
            StringTokenizer tokenizer = new StringTokenizer(line, "\t ,;");
            String token = tokenizer.nextToken();
            int number_of_atoms = Integer.parseInt(token);
            String info = this.input.readLine();
            IChemModel chemModel = (IChemModel)file.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IAtomContainerSet setOfMolecules = (IAtomContainerSet)file.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            IAtomContainer m = (IAtomContainer)file.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            m.setProperty((Object)"cdk:Title", (Object)info);
            String[] types = new String[number_of_atoms];
            double[] d = new double[number_of_atoms];
            int[] d_atom = new int[number_of_atoms];
            double[] a = new double[number_of_atoms];
            int[] a_atom = new int[number_of_atoms];
            double[] da = new double[number_of_atoms];
            int[] da_atom = new int[number_of_atoms];
            int i = 0;
            while (i < number_of_atoms && (line = this.input.readLine()) != null) {
                if (line.startsWith("#")) continue;
                d[i] = 0.0;
                d_atom[i] = -1;
                a[i] = 0.0;
                a_atom[i] = -1;
                da[i] = 0.0;
                da_atom[i] = -1;
                tokenizer = new StringTokenizer(line, "\t ,;");
                int fields = tokenizer.countTokens();
                if (fields < Math.min(i * 2 + 1, 7)) continue;
                if (i == 0) {
                    types[i] = tokenizer.nextToken();
                    ++i;
                    continue;
                }
                if (i == 1) {
                    types[i] = tokenizer.nextToken();
                    d_atom[i] = Integer.valueOf(tokenizer.nextToken()) - 1;
                    d[i] = Double.valueOf(tokenizer.nextToken());
                    ++i;
                    continue;
                }
                if (i == 2) {
                    types[i] = tokenizer.nextToken();
                    d_atom[i] = Integer.valueOf(tokenizer.nextToken()) - 1;
                    d[i] = Double.valueOf(tokenizer.nextToken());
                    a_atom[i] = Integer.valueOf(tokenizer.nextToken()) - 1;
                    a[i] = Double.valueOf(tokenizer.nextToken());
                    ++i;
                    continue;
                }
                types[i] = tokenizer.nextToken();
                d_atom[i] = Integer.valueOf(tokenizer.nextToken()) - 1;
                d[i] = Double.valueOf(tokenizer.nextToken());
                a_atom[i] = Integer.valueOf(tokenizer.nextToken()) - 1;
                a[i] = Double.valueOf(tokenizer.nextToken());
                da_atom[i] = Integer.valueOf(tokenizer.nextToken()) - 1;
                da[i] = Double.valueOf(tokenizer.nextToken());
                ++i;
            }
            Point3d[] cartCoords = ZMatrixTools.zmatrixToCartesian((double[])d, (int[])d_atom, (double[])a, (int[])a_atom, (double[])da, (int[])da_atom);
            for (i = 0; i < number_of_atoms; ++i) {
                m.addAtom((IAtom)file.getBuilder().newInstance(IAtom.class, new Object[]{types[i], cartCoords[i]}));
            }
            setOfMolecules.addAtomContainer(m);
            chemModel.setMoleculeSet(setOfMolecules);
            chemSequence.addChemModel(chemModel);
            line = this.input.readLine();
            file.addChemSequence(chemSequence);
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

