/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.silent.Atom;

public class PDBAtom
extends Atom
implements Cloneable,
IPDBAtom {
    private static final long serialVersionUID = 7670650135045832543L;
    private String record;
    private double tempFactor;
    private String resName;
    private String iCode;
    private double occupancy;
    private String name;
    private String chainID;
    private String altLoc;
    private String segID;
    private int serial;
    private String resSeq;
    private boolean oxt;
    private boolean hetAtom;

    public PDBAtom(IElement element) {
        super(element);
        this.initValues();
    }

    public PDBAtom(String symbol) {
        super(symbol);
        this.initValues();
    }

    public PDBAtom(String symbol, Point3d coordinate) {
        super(symbol, coordinate);
        this.initValues();
    }

    private void initValues() {
        this.record = null;
        this.tempFactor = -1.0;
        this.resName = null;
        this.iCode = null;
        this.occupancy = -1.0;
        this.name = null;
        this.chainID = null;
        this.altLoc = null;
        this.segID = null;
        this.serial = 0;
        this.resSeq = null;
        this.oxt = false;
        this.hetAtom = false;
        this.charge = 0.0;
        this.formalCharge = 0;
    }

    public String getRecord() {
        return this.record;
    }

    public void setRecord(String newRecord) {
        this.record = newRecord;
    }

    public Double getTempFactor() {
        return this.tempFactor;
    }

    public void setTempFactor(Double newTempFactor) {
        this.tempFactor = newTempFactor;
    }

    public void setResName(String newResName) {
        this.resName = newResName;
    }

    public String getResName() {
        return this.resName;
    }

    public void setICode(String newICode) {
        this.iCode = newICode;
    }

    public String getICode() {
        return this.iCode;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public void setChainID(String newChainID) {
        this.chainID = newChainID;
    }

    public String getChainID() {
        return this.chainID;
    }

    public void setAltLoc(String newAltLoc) {
        this.altLoc = newAltLoc;
    }

    public String getAltLoc() {
        return this.altLoc;
    }

    public void setSegID(String newSegID) {
        this.segID = newSegID;
    }

    public String getSegID() {
        return this.segID;
    }

    public void setSerial(Integer newSerial) {
        this.serial = newSerial;
    }

    public Integer getSerial() {
        return this.serial;
    }

    public void setResSeq(String newResSeq) {
        this.resSeq = newResSeq;
    }

    public String getResSeq() {
        return this.resSeq;
    }

    public void setOxt(Boolean newOxt) {
        this.oxt = newOxt;
    }

    public Boolean getOxt() {
        return this.oxt;
    }

    public void setHetAtom(Boolean newHetAtom) {
        this.hetAtom = newHetAtom;
    }

    public Boolean getHetAtom() {
        return this.hetAtom;
    }

    public void setOccupancy(Double newOccupancy) {
        this.occupancy = newOccupancy;
    }

    public Double getOccupancy() {
        return this.occupancy;
    }

    @Override
    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("PDBAtom(");
        description.append(this.hashCode()).append(", ");
        description.append("altLoc=").append(this.getAltLoc()).append(", ");
        description.append("chainID=").append(this.getChainID()).append(", ");
        description.append("iCode=").append(this.getICode()).append(", ");
        description.append("name=").append(this.getName()).append(", ");
        description.append("resName=").append(this.getResName()).append(", ");
        description.append("resSeq=").append(this.getResSeq()).append(", ");
        description.append("segID=").append(this.getSegID()).append(", ");
        description.append("serial=").append(this.getSerial()).append(", ");
        description.append("tempFactor=").append(this.getTempFactor()).append(", ");
        description.append("oxt=").append(this.getOxt()).append(", ");
        description.append("hetatm=").append(this.getHetAtom()).append(", ");
        description.append(super.toString());
        description.append(")");
        return description.toString();
    }
}

