/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class RingPlacer {
    static final boolean debug = false;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RingPlacer.class);
    private IAtomContainer molecule;
    private AtomPlacer atomPlacer = new AtomPlacer();
    static int FUSED = 0;
    static int BRIDGED = 1;
    static int SPIRO = 2;
    public static final Map<Integer, Double> defaultAngles = new HashMap<Integer, Double>();
    public static final Map<Integer, Double> jcpAngles;

    public void placeRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        int sharedAtomCount = sharedAtoms.getAtomCount();
        logger.debug((Object)("placeRing -> sharedAtomCount: " + sharedAtomCount));
        if (sharedAtomCount > 2) {
            this.placeBridgedRing(ring, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        } else if (sharedAtomCount == 2) {
            this.placeFusedRing(ring, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        } else if (sharedAtomCount == 1) {
            this.placeSpiroRing(ring, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        }
    }

    public void placeRing(IRing ring, Point2d ringCenter, double bondLength) {
        this.placeRing(ring, ringCenter, bondLength, defaultAngles);
    }

    public void placeRing(IRing ring, Point2d ringCenter, double bondLength, Map<Integer, Double> startAngles) {
        double radius = this.getNativeRingRadius(ring, bondLength);
        double addAngle = Math.PI * 2 / (double)ring.getRingSize();
        IAtom startAtom = ring.getFirstAtom();
        Point2d p = new Point2d(ringCenter.x + radius, ringCenter.y);
        startAtom.setPoint2d(p);
        double startAngle = 1.5707963267948966;
        int ringSize = ring.getRingSize();
        if (startAngles.get(ringSize) != null) {
            startAngle = startAngles.get(ringSize);
        }
        List bonds = ring.getConnectedBondsList(startAtom);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        IAtom currentAtom = startAtom;
        IBond currentBond = (IBond)bonds.get(0);
        for (int i = 0; i < ring.getBondCount(); ++i) {
            currentBond = ring.getNextBond(currentBond, currentAtom);
            currentAtom = currentBond.getConnectedAtom(currentAtom);
            atomsToDraw.addElement(currentAtom);
        }
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle, radius);
    }

    public IAtomContainer placeRingSubstituents(IRingSet rs, double bondLength) {
        logger.debug((Object)"RingPlacer.placeRingSubstituents() start");
        IRing ring = null;
        IAtom atom = null;
        IRingSet rings = null;
        IAtomContainer unplacedPartners = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer sharedAtoms = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer primaryAtoms = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer treatedAtoms = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        Point2d centerOfRingGravity = null;
        for (int j = 0; j < rs.getAtomContainerCount(); ++j) {
            ring = (IRing)rs.getAtomContainer(j);
            for (int k = 0; k < ring.getAtomCount(); ++k) {
                unplacedPartners.removeAllElements();
                sharedAtoms.removeAllElements();
                primaryAtoms.removeAllElements();
                atom = ring.getAtom(k);
                rings = rs.getRings(atom);
                centerOfRingGravity = GeometryTools.get2DCenter((IRingSet)rings);
                this.atomPlacer.partitionPartners(atom, unplacedPartners, sharedAtoms);
                AtomPlacer.markNotPlaced(unplacedPartners);
                try {
                    for (int f = 0; f < unplacedPartners.getAtomCount(); ++f) {
                        logger.debug((Object)("placeRingSubstituents->unplacedPartners: " + (this.molecule.getAtomNumber(unplacedPartners.getAtom(f)) + 1)));
                    }
                }
                catch (Exception exc) {
                    // empty catch block
                }
                treatedAtoms.add(unplacedPartners);
                if (unplacedPartners.getAtomCount() <= 0) continue;
                this.atomPlacer.distributePartners(atom, sharedAtoms, centerOfRingGravity, unplacedPartners, bondLength);
            }
        }
        logger.debug((Object)"RingPlacer.placeRingSubstituents() end");
        return treatedAtoms;
    }

    private void placeBridgedRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        IAtom startAtom;
        double radius = this.getNativeRingRadius(ring, bondLength);
        Point2d ringCenter = new Point2d(sharedAtomsCenter);
        ringCenterVector.normalize();
        logger.debug((Object)("placeBridgedRing->: ringCenterVector.length()" + ringCenterVector.length()));
        ringCenterVector.scale(radius);
        ringCenter.add((Tuple2d)ringCenterVector);
        IAtom[] bridgeAtoms = this.getBridgeAtoms(sharedAtoms);
        IAtom bondAtom1 = bridgeAtoms[0];
        IAtom bondAtom2 = bridgeAtoms[1];
        Vector2d bondAtom1Vector = new Vector2d((Tuple2d)bondAtom1.getPoint2d());
        Vector2d bondAtom2Vector = new Vector2d((Tuple2d)bondAtom2.getPoint2d());
        Vector2d originRingCenterVector = new Vector2d((Tuple2d)ringCenter);
        bondAtom1Vector.sub((Tuple2d)originRingCenterVector);
        bondAtom2Vector.sub((Tuple2d)originRingCenterVector);
        double occupiedAngle = bondAtom1Vector.angle(bondAtom2Vector);
        double remainingAngle = Math.PI * 2 - occupiedAngle;
        double addAngle = remainingAngle / (double)(ring.getRingSize() - sharedAtoms.getAtomCount() + 1);
        logger.debug((Object)("placeBridgedRing->occupiedAngle: " + Math.toDegrees(occupiedAngle)));
        logger.debug((Object)("placeBridgedRing->remainingAngle: " + Math.toDegrees(remainingAngle)));
        logger.debug((Object)("placeBridgedRing->addAngle: " + Math.toDegrees(addAngle)));
        double centerX = ringCenter.x;
        double centerY = ringCenter.y;
        double xDiff = bondAtom1.getPoint2d().x - bondAtom2.getPoint2d().x;
        double yDiff = bondAtom1.getPoint2d().y - bondAtom2.getPoint2d().y;
        int direction = 1;
        if (xDiff == 0.0) {
            logger.debug((Object)"placeBridgedRing->Bond is vertical");
            startAtom = bondAtom1.getPoint2d().y > bondAtom2.getPoint2d().y ? bondAtom1 : bondAtom2;
            direction = centerX < bondAtom1.getPoint2d().x ? 1 : -1;
        } else {
            startAtom = bondAtom1.getPoint2d().x > bondAtom2.getPoint2d().x ? bondAtom1 : bondAtom2;
            direction = centerY - bondAtom1.getPoint2d().y > (centerX - bondAtom1.getPoint2d().x) * yDiff / xDiff ? 1 : -1;
        }
        double startAngle = GeometryTools.getAngle((double)(startAtom.getPoint2d().x - ringCenter.x), (double)(startAtom.getPoint2d().y - ringCenter.y));
        IAtom currentAtom = startAtom;
        boolean k = false;
        IBond currentBond = sharedAtoms.getBond(0);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        for (int i = 0; i < ring.getBondCount(); ++i) {
            if (sharedAtoms.contains(currentAtom = (currentBond = ring.getNextBond(currentBond, currentAtom)).getConnectedAtom(currentAtom))) continue;
            atomsToDraw.addElement(currentAtom);
        }
        try {
            logger.debug((Object)("placeBridgedRing->atomsToPlace: " + AtomPlacer.listNumbers(this.molecule, atomsToDraw)));
            logger.debug((Object)("placeBridgedRing->startAtom is: " + (this.molecule.getAtomNumber(startAtom) + 1)));
            logger.debug((Object)("placeBridgedRing->startAngle: " + Math.toDegrees(startAngle)));
            logger.debug((Object)("placeBridgedRing->addAngle: " + Math.toDegrees(addAngle)));
        }
        catch (Exception exc) {
            logger.debug((Object)"Caught an exception while logging in RingPlacer");
        }
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle *= (double)direction, radius);
    }

    public void placeSpiroRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        IAtom startAtom;
        logger.debug((Object)"placeSpiroRing");
        double radius = this.getNativeRingRadius(ring, bondLength);
        Point2d ringCenter = new Point2d(sharedAtomsCenter);
        ringCenterVector.normalize();
        ringCenterVector.scale(radius);
        ringCenter.add((Tuple2d)ringCenterVector);
        double addAngle = Math.PI * 2 / (double)ring.getRingSize();
        IAtom currentAtom = startAtom = sharedAtoms.getAtom(0);
        double startAngle = GeometryTools.getAngle((double)(startAtom.getPoint2d().x - ringCenter.x), (double)(startAtom.getPoint2d().y - ringCenter.y));
        List bonds = ring.getConnectedBondsList(startAtom);
        IBond currentBond = (IBond)bonds.get(0);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        for (int i = 0; i < ring.getBondCount(); ++i) {
            currentBond = ring.getNextBond(currentBond, currentAtom);
            currentAtom = currentBond.getConnectedAtom(currentAtom);
            atomsToDraw.addElement(currentAtom);
        }
        logger.debug((Object)("currentAtom  " + currentAtom));
        logger.debug((Object)("startAtom  " + startAtom));
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle, radius);
    }

    public void placeFusedRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        IAtom startAtom;
        logger.debug((Object)"RingPlacer.placeFusedRing() start");
        Point2d ringCenter = new Point2d(sharedAtomsCenter);
        double radius = this.getNativeRingRadius(ring, bondLength);
        double newRingPerpendicular = Math.sqrt(Math.pow(radius, 2.0) - Math.pow(bondLength / 2.0, 2.0));
        ringCenterVector.normalize();
        logger.debug((Object)("placeFusedRing->: ringCenterVector.length()" + ringCenterVector.length()));
        ringCenterVector.scale(newRingPerpendicular);
        ringCenter.add((Tuple2d)ringCenterVector);
        IAtom bondAtom1 = sharedAtoms.getAtom(0);
        IAtom bondAtom2 = sharedAtoms.getAtom(1);
        Vector2d bondAtom1Vector = new Vector2d((Tuple2d)bondAtom1.getPoint2d());
        Vector2d bondAtom2Vector = new Vector2d((Tuple2d)bondAtom2.getPoint2d());
        Vector2d originRingCenterVector = new Vector2d((Tuple2d)ringCenter);
        bondAtom1Vector.sub((Tuple2d)originRingCenterVector);
        bondAtom2Vector.sub((Tuple2d)originRingCenterVector);
        double occupiedAngle = bondAtom1Vector.angle(bondAtom2Vector);
        double remainingAngle = Math.PI * 2 - occupiedAngle;
        double addAngle = remainingAngle / (double)(ring.getRingSize() - 1);
        logger.debug((Object)("placeFusedRing->occupiedAngle: " + Math.toDegrees(occupiedAngle)));
        logger.debug((Object)("placeFusedRing->remainingAngle: " + Math.toDegrees(remainingAngle)));
        logger.debug((Object)("placeFusedRing->addAngle: " + Math.toDegrees(addAngle)));
        double centerX = ringCenter.x;
        double centerY = ringCenter.y;
        double xDiff = bondAtom1.getPoint2d().x - bondAtom2.getPoint2d().x;
        double yDiff = bondAtom1.getPoint2d().y - bondAtom2.getPoint2d().y;
        int direction = 1;
        if (xDiff == 0.0) {
            logger.debug((Object)"placeFusedRing->Bond is vertical");
            startAtom = bondAtom1.getPoint2d().y > bondAtom2.getPoint2d().y ? bondAtom1 : bondAtom2;
            direction = centerX < bondAtom1.getPoint2d().x ? 1 : -1;
        } else {
            startAtom = bondAtom1.getPoint2d().x > bondAtom2.getPoint2d().x ? bondAtom1 : bondAtom2;
            direction = centerY - bondAtom1.getPoint2d().y > (centerX - bondAtom1.getPoint2d().x) * yDiff / xDiff ? 1 : -1;
        }
        double startAngle = GeometryTools.getAngle((double)(startAtom.getPoint2d().x - ringCenter.x), (double)(startAtom.getPoint2d().y - ringCenter.y));
        IAtom currentAtom = startAtom;
        IBond currentBond = sharedAtoms.getBond(0);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        for (int i = 0; i < ring.getBondCount() - 2; ++i) {
            currentBond = ring.getNextBond(currentBond, currentAtom);
            currentAtom = currentBond.getConnectedAtom(currentAtom);
            atomsToDraw.addElement(currentAtom);
        }
        addAngle *= (double)direction;
        try {
            logger.debug((Object)("placeFusedRing->startAngle: " + Math.toDegrees(startAngle)));
            logger.debug((Object)("placeFusedRing->addAngle: " + Math.toDegrees(addAngle)));
            logger.debug((Object)("placeFusedRing->startAtom is: " + (this.molecule.getAtomNumber(startAtom) + 1)));
            logger.debug((Object)("AtomsToDraw: " + AtomPlacer.listNumbers(this.molecule, atomsToDraw)));
        }
        catch (Exception exc) {
            logger.debug((Object)"Caught an exception while logging in RingPlacer");
        }
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle, radius);
    }

    public boolean allPlaced(IRingSet rs) {
        for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
            if (((IRing)rs.getAtomContainer(i)).getFlag(1)) continue;
            return false;
        }
        return true;
    }

    public void checkAndMarkPlaced(IRingSet rs) {
        IRing ring = null;
        boolean allPlaced = true;
        for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
            ring = (IRing)rs.getAtomContainer(i);
            allPlaced = true;
            for (int j = 0; j < ring.getAtomCount(); ++j) {
                if (ring.getAtom(j).getFlag(1)) continue;
                allPlaced = false;
                break;
            }
            ring.setFlag(1, allPlaced);
        }
    }

    private IAtom[] getBridgeAtoms(IAtomContainer sharedAtoms) {
        IAtom[] bridgeAtoms = new IAtom[2];
        int counter = 0;
        for (int f = 0; f < sharedAtoms.getAtomCount(); ++f) {
            IAtom atom = sharedAtoms.getAtom(f);
            if (sharedAtoms.getConnectedAtomsList(atom).size() != 1) continue;
            bridgeAtoms[counter] = atom;
            ++counter;
        }
        return bridgeAtoms;
    }

    public void partitionNonRingPartners(IAtom atom, IRing ring, IAtomContainer ringAtoms, IAtomContainer nonRingAtoms) {
        List atoms = this.molecule.getConnectedAtomsList(atom);
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curAtom = (IAtom)atoms.get(i);
            if (!ring.contains(curAtom)) {
                nonRingAtoms.addAtom(curAtom);
                continue;
            }
            ringAtoms.addAtom(curAtom);
        }
    }

    public double getNativeRingRadius(IRing ring, double bondLength) {
        int size = ring.getAtomCount();
        double radius = bondLength / (2.0 * Math.sin(Math.PI / (double)size));
        return radius;
    }

    Vector2d getRingCenterOfFirstRing(IRing ring, Vector2d bondVector, double bondLength) {
        int size = ring.getAtomCount();
        double radius = bondLength / (2.0 * Math.sin(Math.PI / (double)size));
        double newRingPerpendicular = Math.sqrt(Math.pow(radius, 2.0) - Math.pow(bondLength / 2.0, 2.0));
        double rotangle = GeometryTools.getAngle((double)bondVector.x, (double)bondVector.y);
        return new Vector2d(Math.cos(rotangle += 1.5707963267948966) * newRingPerpendicular, Math.sin(rotangle) * newRingPerpendicular);
    }

    void placeConnectedRings(IRingSet rs, IRing ring, int handleType, double bondLength) {
        IRingSet connectedRings = rs.getConnectedRings(ring);
        for (IAtomContainer container : connectedRings.atomContainers()) {
            IRing connectedRing = (IRing)container;
            if (connectedRing.getFlag(1)) continue;
            IAtomContainer sharedAtoms = AtomContainerManipulator.getIntersection((IAtomContainer)ring, (IAtomContainer)connectedRing);
            int sac = sharedAtoms.getAtomCount();
            logger.debug((Object)("placeConnectedRings-> connectedRing: " + ring.toString()));
            if (!(sac == 2 && handleType == FUSED || sac == 1 && handleType == SPIRO) && (sac <= 2 || handleType != BRIDGED)) continue;
            Point2d sharedAtomsCenter = GeometryTools.get2DCenter((IAtomContainer)sharedAtoms);
            Point2d oldRingCenter = GeometryTools.get2DCenter((IAtomContainer)ring);
            Vector2d tempVector = new Vector2d((Tuple2d)sharedAtomsCenter);
            Vector2d newRingCenterVector = new Vector2d(tempVector);
            newRingCenterVector.sub((Tuple2d)new Vector2d((Tuple2d)oldRingCenter));
            Vector2d oldRingCenterVector = new Vector2d(newRingCenterVector);
            logger.debug((Object)("placeConnectedRing -> tempVector: " + tempVector + ", tempVector.length: " + tempVector.length()));
            logger.debug((Object)("placeConnectedRing -> bondCenter: " + sharedAtomsCenter));
            logger.debug((Object)("placeConnectedRing -> oldRingCenterVector.length(): " + oldRingCenterVector.length()));
            logger.debug((Object)("placeConnectedRing -> newRingCenterVector.length(): " + newRingCenterVector.length()));
            Point2d tempPoint = new Point2d(sharedAtomsCenter);
            tempPoint.add((Tuple2d)newRingCenterVector);
            this.placeRing(connectedRing, sharedAtoms, sharedAtomsCenter, newRingCenterVector, bondLength);
            connectedRing.setFlag(1, true);
            this.placeConnectedRings(rs, connectedRing, handleType, bondLength);
        }
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public AtomPlacer getAtomPlacer() {
        return this.atomPlacer;
    }

    public void setAtomPlacer(AtomPlacer atomPlacer) {
        this.atomPlacer = atomPlacer;
    }

    static {
        defaultAngles.put(3, 0.523598880318054);
        defaultAngles.put(4, 0.7853981633974483);
        defaultAngles.put(5, 0.9424777960769379);
        defaultAngles.put(7, 0.21991148575128555);
        defaultAngles.put(8, 0.39269908169872414);
        jcpAngles = new HashMap<Integer, Double>();
        jcpAngles.put(3, 1.5707963267948966);
        jcpAngles.put(4, 0.7853981633974483);
        jcpAngles.put(5, 1.5707963267948966);
        jcpAngles.put(7, 0.21991148575128555);
        jcpAngles.put(8, 0.39269908169872414);
    }
}

