/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IReaction;

public class CDKDictionaryReferences {
    private static String prefix = "org.openscience.cdk.dict";

    public static void makeReferencesExplicit(IChemObject object) {
        if (object instanceof IAtom) {
            CDKDictionaryReferences.makeReferencesExplicitForAtom((IAtom)object);
        } else if (object instanceof IBond) {
            CDKDictionaryReferences.makeReferencesExplicitForBond((IBond)object);
        } else if (object instanceof IChemModel) {
            CDKDictionaryReferences.makeReferencesExplicitForChemModel((IChemModel)object);
        } else if (object instanceof IIsotope) {
            CDKDictionaryReferences.makeReferencesExplicitForIsotope((IIsotope)object);
        } else if (object instanceof IElement) {
            CDKDictionaryReferences.makeReferencesExplicitForElement((IElement)object);
        } else if (object instanceof IAtomContainer) {
            CDKDictionaryReferences.makeReferencesExplicitForMolecule((IAtomContainer)object);
        } else if (object instanceof IReaction) {
            CDKDictionaryReferences.makeReferencesExplicitForReaction((IReaction)object);
        }
    }

    private static void makeReferencesExplicitForAtom(IAtom atom) {
        int selfCounter = 0;
        atom.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"chemical:atom");
        CDKDictionaryReferences.makeReferencesExplicitForElement((IElement)atom);
    }

    private static void makeReferencesExplicitForBond(IBond bond) {
        int selfCounter = 0;
        bond.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"chemical:covalentBond");
        bond.setProperty((Object)(prefix + ":field:order"), (Object)"chemical:bondOrder");
    }

    private static void makeReferencesExplicitForChemModel(IChemModel model) {
    }

    private static void makeReferencesExplicitForElement(IElement element) {
        int selfCounter = 0;
        element.setProperty((Object)(prefix + ":field:symbol"), (Object)"chemical:atomSymbol");
        element.setProperty((Object)(prefix + ":field:atomicNumber"), (Object)"chemical:atomicNumber");
        if (element.getSymbol().equals("C")) {
            element.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"element:carbon");
        } else if (element.getSymbol().equals("N")) {
            element.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"element:nitrogen");
        } else if (element.getSymbol().equals("O")) {
            element.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"element:oxygen");
        } else if (element.getSymbol().equals("H")) {
            element.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"element:hydrogen");
        } else if (element.getSymbol().equals("S")) {
            element.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"element:sulphur");
        } else if (element.getSymbol().equals("P")) {
            element.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"element:phosphorus");
        }
    }

    private static void makeReferencesExplicitForIsotope(IIsotope isotope) {
        int selfCounter = 0;
        isotope.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"chemical:isotope");
    }

    private static void makeReferencesExplicitForMolecule(IAtomContainer molecule) {
        int selfCounter = 0;
        molecule.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"chemical:molecularEntity");
    }

    private static void makeReferencesExplicitForReaction(IReaction reaction) {
        int selfCounter = 0;
        reaction.setProperty((Object)(prefix + ":self:" + selfCounter++), (Object)"reaction:reactionStep");
    }
}

