/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.rgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKMCS;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRMap;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKRMapHandler;
import org.openscience.cdk.smsd.helper.FinalMappings;
import org.openscience.cdk.smsd.interfaces.AbstractSubGraph;
import org.openscience.cdk.smsd.interfaces.IMCSBase;
import org.openscience.cdk.smsd.tools.MolHandler;

@TestClass(value="org.openscience.cdk.smsd.algorithm.cdk.CDKMCSHandlerTest")
public class CDKSubGraphHandler
extends AbstractSubGraph
implements IMCSBase {
    private IAtomContainer source;
    private IAtomContainer target;
    private boolean rOnPFlag = false;
    private List<Map<IAtom, IAtom>> allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
    private Map<IAtom, IAtom> firstAtomMCS = new HashMap<IAtom, IAtom>();
    private Map<Integer, Integer> firstMCS = new TreeMap<Integer, Integer>();
    private List<Map<Integer, Integer>> allMCS = new ArrayList<Map<Integer, Integer>>();

    @Override
    @TestMethod(value="testSet_MolHandler_MolHandler")
    public void set(MolHandler source, MolHandler target) {
        this.source = source.getMolecule();
        this.target = target.getMolecule();
    }

    @Override
    @TestMethod(value="testSet_IQueryAtomContainer_MolHandler")
    public void set(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
    }

    @Override
    @TestMethod(value="testSearchMCS")
    public boolean isSubgraph(boolean shouldMatchBonds) {
        CDKRMapHandler rmap = new CDKRMapHandler();
        try {
            if (this.source.getAtomCount() == this.target.getAtomCount() && this.source.getBondCount() == this.target.getBondCount()) {
                this.rOnPFlag = true;
                rmap.calculateIsomorphs(this.source, this.target, shouldMatchBonds);
            } else if (this.source.getAtomCount() > this.target.getAtomCount() && this.source.getBondCount() != this.target.getBondCount()) {
                this.rOnPFlag = true;
                rmap.calculateSubGraphs(this.source, this.target, shouldMatchBonds);
            } else {
                this.rOnPFlag = false;
                rmap.calculateSubGraphs(this.target, this.source, shouldMatchBonds);
            }
            this.setAllMapping();
            this.setAllAtomMapping();
            this.setFirstMapping();
            this.setFirstAtomMapping();
        }
        catch (CDKException e) {
            rmap = null;
        }
        return !this.getFirstMapping().isEmpty();
    }

    protected IAtomContainerSet getUncommon(IAtomContainer mol, IAtomContainer mcss, boolean shouldMatchBonds) throws CDKException {
        ArrayList<Integer> atomSerialsToDelete = new ArrayList<Integer>();
        List<List<CDKRMap>> matches = CDKMCS.getSubgraphAtomsMaps(mol, mcss, shouldMatchBonds);
        List<CDKRMap> mapList = matches.get(0);
        Iterator<CDKRMap> i$ = mapList.iterator();
        while (i$.hasNext()) {
            CDKRMap o;
            CDKRMap rmap = o = i$.next();
            atomSerialsToDelete.add(rmap.getId1());
        }
        ArrayList<IAtom> atomsToDelete = new ArrayList<IAtom>();
        for (Integer serial : atomSerialsToDelete) {
            atomsToDelete.add(mol.getAtom(serial.intValue()));
        }
        for (IAtom atom : atomsToDelete) {
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
        return ConnectivityChecker.partitionIntoMolecules((IAtomContainer)mol);
    }

    private synchronized void setAllMapping() {
        try {
            List<Map<Integer, Integer>> sol = FinalMappings.getInstance().getFinalMapping();
            int counter = 0;
            for (Map<Integer, Integer> final_solution : sol) {
                TreeMap<Integer, Integer> atomMappings = new TreeMap<Integer, Integer>();
                for (Map.Entry<Integer, Integer> Solutions : final_solution.entrySet()) {
                    int IIndex = Solutions.getKey();
                    int JIndex = Solutions.getValue();
                    if (this.rOnPFlag) {
                        atomMappings.put(IIndex, JIndex);
                        continue;
                    }
                    atomMappings.put(JIndex, IIndex);
                }
                if (this.allMCS.contains(atomMappings)) continue;
                this.allMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception ex) {
            ex.getCause();
        }
    }

    private synchronized void setAllAtomMapping() {
        List<Map<Integer, Integer>> sol = this.allMCS;
        int counter = 0;
        for (Map<Integer, Integer> final_solution : sol) {
            HashMap<IAtom, IAtom> atomMappings = new HashMap<IAtom, IAtom>();
            for (Map.Entry<Integer, Integer> Solutions : final_solution.entrySet()) {
                int IIndex = Solutions.getKey();
                int JIndex = Solutions.getValue();
                IAtom sourceAtom = null;
                IAtom targetAtom = null;
                sourceAtom = this.source.getAtom(IIndex);
                targetAtom = this.target.getAtom(JIndex);
                atomMappings.put(sourceAtom, targetAtom);
            }
            this.allAtomMCS.add(counter++, atomMappings);
        }
    }

    private synchronized void setFirstMapping() {
        if (!this.allMCS.isEmpty()) {
            this.firstMCS = new TreeMap<Integer, Integer>(this.allMCS.get(0));
        }
    }

    private synchronized void setFirstAtomMapping() {
        if (!this.allAtomMCS.isEmpty()) {
            this.firstAtomMCS = new HashMap<IAtom, IAtom>(this.allAtomMCS.get(0));
        }
    }

    @Override
    @TestMethod(value="testGetAllMapping")
    public List<Map<Integer, Integer>> getAllMapping() {
        return Collections.unmodifiableList(this.allMCS);
    }

    @Override
    @TestMethod(value="testGetFirstMapping")
    public Map<Integer, Integer> getFirstMapping() {
        return Collections.unmodifiableMap(this.firstMCS);
    }

    @Override
    @TestMethod(value="testGetAllAtomMapping")
    public List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    @TestMethod(value="testGetFirstAtomMapping")
    public Map<IAtom, IAtom> getFirstAtomMapping() {
        return Collections.unmodifiableMap(this.firstAtomMCS);
    }
}

