/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.beam.ArbitraryMatching;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.BiconnectedComponents;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.IntSet;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Matching;
import uk.ac.ebi.beam.MaximumMatching;

final class Localise {
    private final Graph delocalised;
    private final Graph localised;
    private final BitSet subset;
    private final Map<Edge, Edge> edgeAssignments = new HashMap<Edge, Edge>();

    private Localise(Graph delocalised, BitSet subset, BitSet aromatic) throws InvalidSmilesException {
        this.delocalised = delocalised;
        this.localised = new Graph(delocalised.order());
        this.subset = subset;
        Matching m = MaximumMatching.maximise(delocalised, ArbitraryMatching.of(delocalised, subset), IntSet.fromBitSet(subset));
        int u = subset.nextSetBit(0);
        while (u >= 0) {
            if (m.unmatched(u)) {
                throw new InvalidSmilesException("a valid kekul\u00e9 structure could not be assigned");
            }
            int v = m.other(u);
            subset.clear(v);
            this.edgeAssignments.put(delocalised.edge(u, v), Bond.DOUBLE_AROMATIC.edge(u, v));
            u = subset.nextSetBit(u + 1);
        }
        for (int v = 0; v < delocalised.order(); ++v) {
            this.localised.addAtom(delocalised.atom(v).toAliphatic());
            this.localised.addTopology(delocalised.topologyOf(v));
        }
        block7: for (Edge orgEdge : delocalised.edges()) {
            Edge newEdge = this.edgeAssignments.get(orgEdge);
            if (newEdge != null) {
                this.localised.addEdge(newEdge);
                continue;
            }
            switch (orgEdge.bond()) {
                case SINGLE: {
                    this.localised.addEdge(Bond.IMPLICIT.edge(orgEdge.either(), orgEdge.other(orgEdge.either())));
                    continue block7;
                }
                case AROMATIC: {
                    this.localised.addEdge(Bond.IMPLICIT_AROMATIC.edge(orgEdge.either(), orgEdge.other(orgEdge.either())));
                    continue block7;
                }
                case IMPLICIT: {
                    int u2 = orgEdge.either();
                    int v = orgEdge.other(u2);
                    if (aromatic.get(u2) && aromatic.get(v)) {
                        this.localised.addEdge(Bond.IMPLICIT_AROMATIC.edge(orgEdge.either(), orgEdge.other(orgEdge.either())));
                        continue block7;
                    }
                    this.localised.addEdge(orgEdge);
                    continue block7;
                }
            }
            this.localised.addEdge(orgEdge);
        }
    }

    static BitSet buildSet(Graph g, BitSet aromatic) {
        BitSet undecided = new BitSet(g.order());
        for (int v = 0; v < g.order(); ++v) {
            if (!g.atom(v).aromatic()) continue;
            aromatic.set(v);
            if (Localise.predetermined(g, v)) continue;
            undecided.set(v);
        }
        return undecided;
    }

    static boolean predetermined(Graph g, int v) {
        Atom a = g.atom(v);
        int q = a.charge();
        int deg = g.degree(v) + g.implHCount(v);
        for (Edge e : g.edges(v)) {
            if (e.bond() == Bond.DOUBLE) {
                return q != 0 || a.element() != Element.Nitrogen && (a.element() != Element.Sulfur || deg <= 3) || g.atom(e.other(v)).element() != Element.Oxygen;
            }
            if (e.bond().order() <= 2) continue;
            return true;
        }
        switch (a.element()) {
            case Carbon: {
                return (q == 1 || q == -1) && deg == 3;
            }
            case Silicon: 
            case Germanium: {
                return q < 0;
            }
            case Nitrogen: 
            case Phosphorus: 
            case Arsenic: 
            case Antimony: {
                if (q == 0) {
                    return deg == 3;
                }
                if (q == 1) {
                    return deg != 3;
                }
                return true;
            }
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: {
                if (q == 0) {
                    return deg == 2;
                }
                return q < 0;
            }
        }
        return false;
    }

    static Graph resonate(Graph g) {
        int v;
        int u;
        BitSet cyclic = new BiconnectedComponents(g).cyclic();
        BitSet subset = new BitSet();
        int[] count = new int[g.order()];
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge e : g.edges()) {
            if (e.bond() != Bond.DOUBLE) continue;
            u = e.either();
            v = e.other(u);
            if (Localise.hasAdjDirectionalLabels(g, e) || !cyclic.get(u) || !cyclic.get(v)) continue;
            int n = u;
            count[n] = count[n] + 1;
            int n2 = v;
            count[n2] = count[n2] + 1;
            edges.add(e);
        }
        for (Edge e : edges) {
            u = e.either();
            v = e.other(u);
            if (count[u] != 1 || count[v] != 1) continue;
            e.bond(Bond.IMPLICIT);
            subset.set(u);
            subset.set(v);
        }
        Matching m = MaximumMatching.maximise(g.sort(new Graph.CanOrderFirst()), ArbitraryMatching.of(g, subset), IntSet.fromBitSet(subset));
        int v2 = subset.nextSetBit(0);
        while (v2 >= 0) {
            int w = m.other(v2);
            subset.clear(w);
            g.edge(v2, w).bond(Bond.DOUBLE);
            v2 = subset.nextSetBit(v2 + 1);
        }
        return g;
    }

    private static boolean hasAdjDirectionalLabels(Graph g, Edge e) {
        int u = e.either();
        int v = e.other(u);
        return Localise.hasAdjDirectionalLabels(g, u) && Localise.hasAdjDirectionalLabels(g, v);
    }

    private static boolean hasAdjDirectionalLabels(Graph g, int u) {
        for (Edge f : g.edges(u)) {
            if (!f.bond().directional()) continue;
            return true;
        }
        return false;
    }

    static Graph localise(Graph delocalised) throws InvalidSmilesException {
        if (!delocalised.isDelocalised()) {
            return delocalised;
        }
        BitSet aromatic = new BitSet();
        BitSet subset = Localise.buildSet(delocalised, aromatic);
        if (Localise.hasOddCardinality(subset)) {
            throw new InvalidSmilesException("a valid kekul\u00e9 structure could not be assigned");
        }
        return new Localise((Graph)delocalised, (BitSet)subset, (BitSet)aromatic).localised;
    }

    private static boolean hasOddCardinality(BitSet s) {
        return (s.cardinality() & 1) == 1;
    }
}

