/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

final class Generator {
    private final Graph g;
    private final StringBuilder sb;
    private final int[] visitedAt;
    private int i;
    private final AtomToken[] tokens;
    private final Map<Integer, List<RingClosure>> rings;
    private final RingNumbering rnums;

    Generator(Graph g, RingNumbering rnums) throws InvalidSmilesException {
        this(g, new int[g.order()], rnums);
    }

    Generator(Graph g, int[] visitedAt, RingNumbering rnums) throws InvalidSmilesException {
        int u;
        this.g = g;
        this.rnums = rnums;
        this.sb = new StringBuilder(g.order() * 2);
        this.visitedAt = visitedAt;
        this.tokens = new AtomToken[g.order()];
        this.rings = new HashMap<Integer, List<RingClosure>>();
        int visited = 0;
        Arrays.fill(visitedAt, -1);
        boolean uncofiguredStereo = false;
        for (u = 0; u < g.order() && visited < g.order(); ++u) {
            if (visitedAt[u] >= 0) continue;
            uncofiguredStereo = this.prepare(u, u, u == 0 ? Bond.IMPLICIT : Bond.DOT) || uncofiguredStereo;
        }
        if (uncofiguredStereo) {
            for (u = 0; u < g.order(); ++u) {
                if (g.topologyOf(u).configuration().type() != Configuration.Type.ExtendedTetrahedral) continue;
                this.tokens[u].configure(g.topologyOf(u).orderBy(visitedAt).configuration());
            }
        }
        visited = 0;
        this.i = 0;
        Arrays.fill(visitedAt, -1);
        for (u = 0; u < g.order() && visited < g.order(); ++u) {
            if (visitedAt[u] >= 0) continue;
            this.write(u, u, u == 0 ? Bond.IMPLICIT : Bond.DOT);
        }
    }

    boolean prepare(int u, int p, Bond b) {
        ++this.i;
        this.tokens[u] = this.g.atom(u).token();
        boolean uncofiguredStereo = false;
        for (Edge e : this.g.edges(u)) {
            int v = e.other(u);
            if (this.visitedAt[v] < 0) {
                uncofiguredStereo = this.prepare(v, u, e.bond(u)) || uncofiguredStereo;
                continue;
            }
            if (v == p || this.visitedAt[v] >= this.visitedAt[u]) continue;
            this.cyclicEdge(v, u, e.bond(v));
        }
        if (this.g.topologyOf(u).configuration().type() == Configuration.Type.ExtendedTetrahedral) {
            return true;
        }
        if (this.rings.containsKey(u)) {
            this.tokens[u].configure(this.g.topologyOf(u).orderBy(this.localRank(u, p)).configuration());
        } else {
            this.tokens[u].configure(this.g.topologyOf(u).orderBy(this.visitedAt).configuration());
        }
        return uncofiguredStereo;
    }

    void write(int u, int p, Bond b) throws InvalidSmilesException {
        ++this.i;
        int remaining = this.g.degree(u);
        if (u != p) {
            --remaining;
        }
        if (this.rings.containsKey(u)) {
            for (RingClosure rc : this.rings.get(u)) {
                int rnum;
                if (rc.register(rnum = this.rnums.next())) {
                    int v = rc.other(u);
                    this.tokens[u] = new RingNumberToken(new RingBondToken(this.tokens[u], rc.bond(u)), rnum);
                    this.rnums.use(rnum);
                } else {
                    this.tokens[u] = new RingNumberToken(this.tokens[u], rc.rnum);
                    this.rnums.free(rc.rnum);
                }
                --remaining;
            }
        }
        this.sb.append(b.token());
        this.tokens[u].append(this.sb);
        for (Edge e : this.g.edges(u)) {
            int v = e.other(u);
            if (this.visitedAt[v] >= 0) continue;
            if (--remaining > 0) {
                this.sb.append('(');
                this.write(v, u, e.bond(u));
                this.sb.append(')');
                continue;
            }
            this.write(v, u, e.bond(u));
        }
    }

    private int[] localRank(int u, int p) {
        int[] localRank = new int[this.g.order()];
        int rank = 2;
        localRank[u] = 1;
        for (Edge e : this.g.edges(u)) {
            localRank[e.other((int)u)] = this.g.degree(u) + rank++;
        }
        localRank[p] = 0;
        rank = 2;
        for (RingClosure rc : this.rings.get(u)) {
            localRank[rc.other((int)u)] = rank++;
        }
        return localRank;
    }

    private void cyclicEdge(int u, int v, Bond b) {
        RingClosure r = new RingClosure(u, v, b);
        this.addRing(r.u, r);
        this.addRing(r.v, r);
    }

    private void addRing(int u, RingClosure rc) {
        List<RingClosure> closures = this.rings.get(u);
        if (closures == null) {
            closures = new ArrayList<RingClosure>(2);
            this.rings.put(u, closures);
        }
        closures.add(rc);
    }

    String string() {
        return this.sb.toString();
    }

    static String generate(Graph g) throws InvalidSmilesException {
        return new Generator(g, new IterativeRingNumbering(1)).string();
    }

    static String generate(Graph g, int[] visitedAt) throws InvalidSmilesException {
        return new Generator(g, visitedAt, new IterativeRingNumbering(1)).string();
    }

    static final class IterativeRingNumbering
    implements RingNumbering {
        private boolean[] used = new boolean[100];
        private final int offset;
        private int pos;

        IterativeRingNumbering(int first) {
            this.pos = this.offset = first;
        }

        public int next() throws InvalidSmilesException {
            while (this.pos < 100 && this.used[this.pos]) {
                ++this.pos;
            }
            if (this.pos < 100) {
                return this.pos;
            }
            this.pos = this.offset;
            while (this.pos < 100 && this.used[this.pos]) {
                ++this.pos;
            }
            if (this.pos < 100) {
                return this.pos;
            }
            throw new InvalidSmilesException("no more ring numbers can be assigned");
        }

        public void use(int rnum) {
            this.used[rnum] = true;
        }

        public void free(int rnum) {
            this.used[rnum] = false;
        }
    }

    static final class ReuseRingNumbering
    implements RingNumbering {
        private boolean[] used = new boolean[100];
        private final int offset;

        ReuseRingNumbering(int first) {
            this.offset = first;
        }

        public int next() throws InvalidSmilesException {
            for (int i = this.offset; i < this.used.length; ++i) {
                if (this.used[i]) continue;
                return i;
            }
            throw new InvalidSmilesException("no available ring numbers");
        }

        public void use(int rnum) {
            this.used[rnum] = true;
        }

        public void free(int rnum) {
            this.used[rnum] = false;
        }
    }

    static interface RingNumbering {
        public int next() throws InvalidSmilesException;

        public void use(int var1);

        public void free(int var1);
    }

    static final class RingBondToken
    extends TokenAdapter {
        Bond bond;

        RingBondToken(AtomToken p, Bond bond) {
            super(p);
            this.bond = bond;
        }

        public void append(StringBuilder sb) {
            super.append(sb);
            sb.append((Object)this.bond);
        }
    }

    static final class RingNumberToken
    extends TokenAdapter {
        int rnum;

        RingNumberToken(AtomToken p, int rnum) {
            super(p);
            this.rnum = rnum;
        }

        public void append(StringBuilder sb) {
            super.append(sb);
            if (this.rnum > 9) {
                sb.append('%');
            }
            sb.append(this.rnum);
        }
    }

    static abstract class TokenAdapter
    implements AtomToken {
        private AtomToken parent;

        TokenAdapter(AtomToken parent) {
            this.parent = parent;
        }

        public final void configure(Configuration c) {
            this.parent.configure(c);
        }

        public void append(StringBuilder sb) {
            this.parent.append(sb);
        }
    }

    static final class BracketToken
    implements AtomToken {
        private Atom atom;
        private Configuration c = Configuration.UNKNOWN;

        BracketToken(Atom a) {
            this.atom = a;
        }

        public void configure(Configuration c) {
            this.c = c;
        }

        public void append(StringBuilder sb) {
            sb.append('[');
            if (this.atom.isotope() >= 0) {
                sb.append(this.atom.isotope());
            }
            sb.append(this.atom.aromatic() ? this.atom.element().symbol().toLowerCase(Locale.ENGLISH) : this.atom.element().symbol());
            if (this.c != Configuration.UNKNOWN) {
                sb.append(this.c.shorthand().symbol());
            }
            if (this.atom.hydrogens() > 0) {
                sb.append(Element.Hydrogen.symbol());
            }
            if (this.atom.hydrogens() > 1) {
                sb.append(this.atom.hydrogens());
            }
            if (this.atom.charge() != 0) {
                sb.append(this.atom.charge() > 0 ? (char)'+' : '-');
                int absCharge = Math.abs(this.atom.charge());
                if (absCharge > 1) {
                    sb.append(absCharge);
                }
            }
            if (this.atom.atomClass() != 0) {
                sb.append(':').append(this.atom.atomClass());
            }
            sb.append(']');
        }
    }

    static final class SubsetToken
    implements AtomToken {
        private final String str;

        SubsetToken(String str) {
            this.str = str;
        }

        public void configure(Configuration c) {
        }

        public void append(StringBuilder sb) {
            sb.append(this.str);
        }
    }

    static interface AtomToken {
        public void configure(Configuration var1);

        public void append(StringBuilder var1);
    }

    static final class RingClosure {
        final int u;
        final int v;
        final Bond b;
        int rnum = -1;

        RingClosure(int u, int v, Bond b) {
            this.u = u;
            this.v = v;
            this.b = b;
        }

        int other(int x) {
            if (x == this.u) {
                return this.v;
            }
            if (x == this.v) {
                return this.u;
            }
            throw new IllegalArgumentException("non edge endpoint");
        }

        Bond bond(int x) {
            if (x == this.u) {
                return this.b;
            }
            if (x == this.v) {
                return this.b.inverse();
            }
            throw new IllegalArgumentException("invalid endpoint");
        }

        boolean register(int rnum) {
            if (this.rnum < 0) {
                this.rnum = rnum;
                return true;
            }
            return false;
        }
    }
}

