/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smiles.BeamToCDK;
import uk.ac.ebi.beam.Graph;

@TestClass(value="org.openscience.cdk.smiles.SmilesParserTest")
public final class SmilesParser {
    private final IChemObjectBuilder builder;
    private final BeamToCDK beamToCDK;
    private boolean kekulise = true;

    public SmilesParser(IChemObjectBuilder builder) {
        this.builder = builder;
        this.beamToCDK = new BeamToCDK(builder);
    }

    @TestMethod(value="testReaction,testReactionWithAgents")
    public IReaction parseReactionSmiles(String smiles) throws InvalidSmilesException {
        int i;
        StringTokenizer tokenizer = new StringTokenizer(smiles, ">");
        String reactantSmiles = tokenizer.nextToken();
        String agentSmiles = "";
        String productSmiles = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            agentSmiles = productSmiles;
            productSmiles = tokenizer.nextToken();
        }
        IReaction reaction = (IReaction)this.builder.newInstance(IReaction.class, new Object[0]);
        IAtomContainer reactantContainer = this.parseSmiles(reactantSmiles);
        IAtomContainerSet reactantSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)reactantContainer);
        for (int i2 = 0; i2 < reactantSet.getAtomContainerCount(); ++i2) {
            reaction.addReactant(reactantSet.getAtomContainer(i2));
        }
        if (agentSmiles.length() > 0) {
            IAtomContainer agentContainer = this.parseSmiles(agentSmiles);
            IAtomContainerSet agentSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)agentContainer);
            for (i = 0; i < agentSet.getAtomContainerCount(); ++i) {
                reaction.addAgent(agentSet.getAtomContainer(i));
            }
        }
        IAtomContainer productContainer = this.parseSmiles(productSmiles);
        IAtomContainerSet productSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)productContainer);
        for (i = 0; i < productSet.getAtomContainerCount(); ++i) {
            reaction.addProduct(productSet.getAtomContainer(i));
        }
        return reaction;
    }

    @TestMethod(value="testAromaticSmiles,testSFBug1296113")
    public IAtomContainer parseSmiles(String smiles) throws InvalidSmilesException {
        try {
            Graph g = Graph.fromSmiles((String)smiles);
            return this.beamToCDK.toAtomContainer(this.kekulise ? g.kekule() : g);
        }
        catch (IOException e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "', " + e.getMessage());
        }
    }

    @Deprecated
    public void setPreservingAromaticity(boolean preservingAromaticity) {
        this.kekulise = !preservingAromaticity;
    }

    @Deprecated
    public boolean isPreservingAromaticity() {
        return !this.kekulise;
    }

    public void kekulise(boolean kekulise) {
        this.kekulise = kekulise;
    }
}

