/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.isomorphism.CompatibilityMatrixTest")
final class CompatibilityMatrix {
    final int[] data;
    final int nRows;
    final int mCols;

    CompatibilityMatrix(int nRows, int mCols) {
        this.data = new int[nRows * mCols];
        this.nRows = nRows;
        this.mCols = mCols;
    }

    @TestMethod(value="accessAndModify")
    void set(int i, int j) {
        this.data[i * this.mCols + j] = 1;
    }

    @TestMethod(value="accessAndModify")
    boolean get(int i) {
        return this.data[i] > 0;
    }

    @TestMethod(value="accessAndModify")
    boolean get(int i, int j) {
        return this.get(i * this.mCols + j);
    }

    @TestMethod(value="mark")
    void mark(int i, int j, int marking) {
        this.data[i * this.mCols + j] = marking;
    }

    @TestMethod(value="markRow")
    void markRow(int i, int marking) {
        int j;
        int end = j + this.mCols;
        for (j = i * this.mCols; j < end; ++j) {
            if (this.data[j] <= 0) continue;
            this.data[j] = marking;
        }
    }

    @TestMethod(value="mark")
    void resetRows(int i, int marking) {
        for (int j = i * this.mCols; j < this.data.length; ++j) {
            if (this.data[j] != marking) continue;
            this.data[j] = 1;
        }
    }

    @TestMethod(value="fix")
    int[][] fix() {
        int[][] m = new int[this.nRows][this.mCols];
        for (int i = 0; i < this.nRows; ++i) {
            System.arraycopy(this.data, i * this.mCols, m[i], 0, this.mCols);
        }
        return m;
    }
}

