/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.ringsearch.RingSearch;

@TestClass(value="org.openscience.cdk.aromaticity.PiBondModelTest")
final class PiBondModel
extends ElectronDonation {
    PiBondModel() {
    }

    @Override
    @TestMethod(value="bezene,furan,pyrrole")
    int[] contribution(IAtomContainer container, RingSearch ringSearch) {
        int n = container.getAtomCount();
        int[] electrons = new int[n];
        int[] piBonds = new int[n];
        for (IBond bond : container.bonds()) {
            int u = container.getAtomNumber(bond.getAtom(0));
            int v = container.getAtomNumber(bond.getAtom(1));
            if (bond.getOrder() != IBond.Order.DOUBLE || !ringSearch.cyclic(u, v)) continue;
            int n2 = u;
            piBonds[n2] = piBonds[n2] + 1;
            int n3 = v;
            piBonds[n3] = piBonds[n3] + 1;
        }
        for (int i = 0; i < n; ++i) {
            electrons[i] = piBonds[i] == 1 ? 1 : -1;
        }
        return electrons;
    }
}

