/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class NormaliseDirectionalLabels
extends AbstractFunction<Graph, Graph> {
    NormaliseDirectionalLabels() {
    }

    @Override
    public Graph apply(Graph g) {
        int u;
        Traversal traversal = new Traversal(g);
        Graph h = new Graph(g.order());
        for (u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        for (u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u) continue;
                if (traversal.acc.containsKey(e)) {
                    h.addEdge((Edge)traversal.acc.get(e));
                    continue;
                }
                h.addEdge(e);
            }
        }
        return h.sort(new Graph.CanOrderFirst());
    }

    private static final class Traversal {
        private final Graph g;
        private final boolean[] visited;
        private final int[] ordering;
        private int i;
        private Map<Edge, Edge> acc = new HashMap<Edge, Edge>();
        private List<Edge> doubleBonds = new ArrayList<Edge>();
        private Set<Integer> adj = new HashSet<Integer>();

        private Traversal(Graph g) {
            this.g = g;
            this.visited = new boolean[g.order()];
            this.ordering = new int[g.order()];
            BitSet dbAtoms = new BitSet();
            for (int u = 0; u < g.order(); ++u) {
                if (this.visited[u]) continue;
                dbAtoms.or(this.visit(u, u));
            }
            for (Edge e : this.doubleBonds) {
                this.flip(g, e, dbAtoms);
            }
        }

        private BitSet visit(int p, int u) {
            this.visited[u] = true;
            ++this.i;
            BitSet dbAtoms = new BitSet();
            for (Edge e : this.g.edges(u)) {
                int v = e.other(u);
                if (this.visited[v]) continue;
                if (e.bond() == Bond.DOUBLE && this.hasAdjDirectionalLabels(this.g, e)) {
                    dbAtoms.set(u);
                    dbAtoms.set(v);
                    boolean newSystem = !this.adj.contains(u) && !this.adj.contains(v);
                    for (Edge f : this.g.edges(u)) {
                        this.adj.add(f.other(u));
                    }
                    for (Edge f : this.g.edges(v)) {
                        this.adj.add(f.other(v));
                    }
                    if (newSystem) {
                        this.doubleBonds.add(e);
                    }
                }
                dbAtoms.or(this.visit(u, v));
            }
            return dbAtoms;
        }

        private boolean hasAdjDirectionalLabels(Graph g, Edge e) {
            int u = e.either();
            int v = e.other(u);
            return this.hasAdjDirectionalLabels(g, u) && this.hasAdjDirectionalLabels(g, v);
        }

        private boolean hasAdjDirectionalLabels(Graph g, int u) {
            for (Edge f : g.edges(u)) {
                if (!f.bond().directional()) continue;
                return true;
            }
            return false;
        }

        private void flip(Graph g, Edge e, BitSet dbAtoms) {
            int v;
            int u = e.either();
            if (this.ordering[u] < this.ordering[v = e.other(u)]) {
                Edge first = this.firstDirectionalLabel(g, u);
                if (first != null) {
                    this.flip(first, u, dbAtoms);
                } else {
                    first = this.firstDirectionalLabel(g, v);
                    this.flip(first, v, dbAtoms);
                }
            } else {
                Edge first = this.firstDirectionalLabel(g, v);
                if (first != null) {
                    this.flip(first, v, dbAtoms);
                } else {
                    first = this.firstDirectionalLabel(g, u);
                    this.flip(first, u, dbAtoms);
                }
            }
        }

        private void flip(Edge first, int u, BitSet dbAtoms) {
            if (this.ordering[first.other(u)] < this.ordering[u]) {
                if (first.bond(u) == Bond.UP) {
                    this.invertExistingDirectionalLabels(this.g, new BitSet(), this.acc, dbAtoms, u);
                }
            } else if (first.bond(u) == Bond.DOWN) {
                this.invertExistingDirectionalLabels(this.g, new BitSet(), this.acc, dbAtoms, u);
            }
        }

        Edge firstDirectionalLabel(Graph g, int u) {
            Edge first = null;
            for (Edge f : g.edges(u)) {
                if (f.bond() != Bond.UP && f.bond() != Bond.DOWN || first != null && this.ordering[f.other(u)] >= this.ordering[first.other(u)]) continue;
                first = f;
            }
            return first;
        }

        private void invertExistingDirectionalLabels(Graph g, BitSet visited, Map<Edge, Edge> replacement, BitSet dbAtoms, int u) {
            visited.set(u);
            for (Edge e : g.edges(u)) {
                int v = e.other(u);
                if (visited.get(v)) continue;
                Edge f = replacement.get(e);
                if (f != null) {
                    replacement.put(e, f.inverse());
                } else {
                    replacement.put(e, e.inverse());
                }
                if (!dbAtoms.get(v)) continue;
                this.invertExistingDirectionalLabels(g, visited, replacement, dbAtoms, v);
            }
        }
    }
}

