/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.io.IOException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.renderer.generators.AtomMassGeneratorTest")
public class AtomMassGenerator
extends BasicAtomGenerator {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomMassGenerator.class);

    @Override
    @TestMethod(value="showCarbon_ShowEndCarbonsTest")
    public boolean showCarbon(IAtom atom, IAtomContainer container, RendererModel model) {
        Integer massNumber = atom.getMassNumber();
        if (massNumber != null) {
            try {
                Integer expectedMassNumber = Isotopes.getInstance().getMajorIsotope(atom.getSymbol()).getMassNumber();
                if (massNumber != expectedMassNumber) {
                    return true;
                }
            }
            catch (IOException e) {
                this.logger.warn(e);
            }
        }
        return super.showCarbon(atom, container, model);
    }
}

