/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

@TestClass(value="org.openscience.cdk.renderer.AtomContainerRendererTest")
public class AtomContainerRenderer
extends AbstractRenderer<IAtomContainer>
implements IRenderer<IAtomContainer> {
    public static final double DEFAULT_SCALE = 30.0;

    public AtomContainerRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        this(new RendererModel(), generators, fontManager);
        for (IGenerator<IAtomContainer> generator : generators) {
            this.rendererModel.registerParameters(generator);
        }
    }

    public AtomContainerRenderer(RendererModel rendererModel, List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        super(rendererModel);
        this.generators = generators;
        this.fontManager = fontManager;
    }

    @Override
    public void setup(IAtomContainer atomContainer, Rectangle screen) {
        this.setScale(atomContainer);
        Rectangle2D bounds = BoundsCalculator.calculateBounds(atomContainer);
        this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    public void reset() {
        this.modelCenter = new Point2d(0.0, 0.0);
        this.drawCenter = new Point2d(200.0, 200.0);
        this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).setValue(1.0);
        this.setup();
    }

    @Override
    public void setScale(IAtomContainer atomContainer) {
        double bondLength = GeometryTools.getBondLengthAverage(atomContainer);
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(this.calculateScaleForBondLength(bondLength));
    }

    @Override
    public Rectangle paint(IAtomContainer atomContainer, IDrawVisitor drawVisitor) {
        Rectangle2D modelBounds = BoundsCalculator.calculateBounds(atomContainer);
        this.setupTransformNatural(modelBounds);
        IRenderingElement diagram = this.generateDiagram(atomContainer);
        this.paint(drawVisitor, diagram);
        return this.convertToDiagramBounds(modelBounds);
    }

    private static double estimatedBondLength(IAtomContainer container) {
        if (container.getBondCount() > 0) {
            throw new IllegalArgumentException("structure has at least one bond - disconnected scaling not need");
        }
        if (container.getAtomCount() < 2) {
            throw new IllegalArgumentException("structure must have at least two atoms");
        }
        int nAtoms = container.getAtomCount();
        double minDistance = 2.147483647E9;
        for (int i = 0; i < nAtoms; ++i) {
            for (int j = i + 1; j < nAtoms; ++j) {
                minDistance = Math.min(container.getAtom(i).getPoint2d().distance(container.getAtom(j).getPoint2d()), minDistance);
            }
        }
        return minDistance / 1.5;
    }

    @Override
    public void paint(IAtomContainer atomContainer, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        if (atomContainer.getBondCount() > 0 || atomContainer.getAtomCount() == 1) {
            this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(this.calculateScaleForBondLength(GeometryTools.getBondLengthAverage(atomContainer)));
        } else if (atomContainer.getAtomCount() > 1) {
            this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(this.calculateScaleForBondLength(AtomContainerRenderer.estimatedBondLength(atomContainer)));
        }
        IRenderingElement diagram = this.generateDiagram(atomContainer);
        Rectangle2D modelBounds = this.getBounds(diagram);
        if (modelBounds == null) {
            modelBounds = BoundsCalculator.calculateBounds(atomContainer);
        }
        this.setupTransformToFit(bounds, modelBounds, resetCenter);
        this.paint(drawVisitor, diagram);
    }

    @Override
    public Rectangle calculateDiagramBounds(IAtomContainer atomContainer) {
        return this.calculateScreenBounds(BoundsCalculator.calculateBounds(atomContainer));
    }

    @Override
    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return 30.0;
        }
        return (Double)this.rendererModel.getParameter(BasicSceneGenerator.BondLength.class).getValue() / modelBondLength;
    }

    @Override
    public List<IGenerator<IAtomContainer>> getGenerators() {
        return new ArrayList<IGenerator<IAtomContainer>>(this.generators);
    }
}

