/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.iterator.IteratingSMILESReaderTest")
public class IteratingSMILESReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingSMILESReader.class);
    private SmilesParser sp = null;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IAtomContainer nextMolecule;
    private final IChemObjectBuilder builder;
    public static final String BAD_SMILES_INPUT = "bad.smiles.input";

    @TestMethod(value="testSMILESFileWithNames")
    public IteratingSMILESReader(Reader in, IChemObjectBuilder builder) {
        this.sp = new SmilesParser(builder);
        this.setReader(in);
        this.builder = builder;
    }

    public IteratingSMILESReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testSMILESTitles,testSMILESFile")
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                String line = this.input.readLine();
                if (line == null) {
                    this.nextAvailableIsKnown = true;
                    return false;
                }
                this.hasNext = true;
                String suffix = this.suffix(line);
                this.nextMolecule = this.readSmiles(line);
                this.nextMolecule.setProperty("cdk:Title", suffix);
            }
            catch (Exception exception) {
                logger.error("Unexpeced problem: ", exception.getMessage());
                logger.debug(exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    private String suffix(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c != ' ' && c != '\t') continue;
            return line.substring(i + 1);
        }
        return "";
    }

    private IAtomContainer readSmiles(String line) {
        try {
            return this.sp.parseSmiles(line);
        }
        catch (CDKException e) {
            logger.error("Error while reading the SMILES from: " + line + ", ", e);
            IAtomContainer empty = this.builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
            empty.setProperty(BAD_SMILES_INPUT, line);
            return empty;
        }
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testSMILESTitles,testSMILESFile")
    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testClose")
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    @TestMethod(value="testRemove")
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    @TestMethod(value="testSetReader1,testSetReader_InputStream")
    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }
}

