/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.PCCompoundASNReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemSubstancesASNFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class IteratingPCCompoundASNReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingPCCompoundASNReader.class);
    private IChemObjectBuilder builder;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IAtomContainer nextMolecule;
    private String currentLine;
    private int depth;

    public IteratingPCCompoundASNReader(Reader in, IChemObjectBuilder builder) {
        this.builder = builder;
        this.setReader(in);
    }

    public IteratingPCCompoundASNReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return PubChemSubstancesASNFormat.getInstance();
    }

    @Override
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                int depthDiff;
                this.currentLine = this.input.readLine();
                boolean endMoleculeFound = false;
                boolean startMoleculeFound = false;
                StringBuffer buffer = new StringBuffer();
                while (!startMoleculeFound && this.currentLine != null) {
                    String command;
                    depthDiff = this.countBrackets(this.currentLine);
                    this.depth += depthDiff;
                    if (depthDiff > 0 && this.depth == 3 && (command = this.getCommand(this.currentLine)).equals("compound")) {
                        startMoleculeFound = true;
                        buffer.append("PC-Compound ::= {\n");
                    }
                    this.currentLine = this.input.readLine();
                }
                while (!endMoleculeFound && this.currentLine != null) {
                    depthDiff = this.countBrackets(this.currentLine);
                    this.depth += depthDiff;
                    if (depthDiff < 0 && this.depth == 2) {
                        endMoleculeFound = true;
                        buffer.append("}\n");
                        break;
                    }
                    buffer.append(this.currentLine).append("\n");
                    this.currentLine = this.input.readLine();
                }
                if (startMoleculeFound && endMoleculeFound) {
                    this.hasNext = true;
                    PCCompoundASNReader asnReader = new PCCompoundASNReader(new StringReader(buffer.toString()));
                    IChemFile cFile = (IChemFile)asnReader.read((IChemObject)this.builder.newInstance(IChemFile.class, new Object[0]));
                    asnReader.close();
                    this.nextMolecule = ChemFileManipulator.getAllAtomContainers(cFile).get(0);
                }
            }
            catch (Exception exception) {
                logger.error("Error while reading next molecule: ", exception.getMessage());
                logger.debug(exception);
                exception.printStackTrace();
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    private int countChars(String copy, char character) {
        int occurences = 0;
        for (int i = 0; i < copy.length(); ++i) {
            if (character != copy.charAt(i)) continue;
            ++occurences;
        }
        return occurences;
    }

    private int countBrackets(String currentLine) {
        int bracketsOpen = this.countChars(currentLine, '{');
        int bracketsClose = this.countChars(currentLine, '}');
        return bracketsOpen - bracketsClose;
    }

    @Override
    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String getCommand(String line) {
        StringBuffer buffer = new StringBuffer();
        boolean foundBracket = false;
        for (int i = 0; i < line.length() && !foundBracket; ++i) {
            char currentChar = line.charAt(i);
            if (currentChar == '{') {
                foundBracket = true;
                continue;
            }
            buffer.append(currentChar);
        }
        return foundBracket ? buffer.toString().trim() : null;
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }
}

