/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import java.util.Collections;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class SmallestRingAtom
extends SMARTSAtom {
    private static final long serialVersionUID = 8201040824866400163L;
    private int smallestRingSize;

    public SmallestRingAtom(int size, IChemObjectBuilder builder) {
        super(builder);
        this.smallestRingSize = size;
    }

    public boolean matches(IAtom atom) {
        if (atom.getFlag(2)) {
            List rings = (List)atom.getProperty("cdk:RingSizes");
            if (rings == null || rings.size() == 0) {
                return false;
            }
            Collections.sort(rings);
            if ((Integer)rings.get(0) == this.smallestRingSize) {
                return true;
            }
        }
        return false;
    }
}

