/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.beam.AllCycles;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.ElectronAssignment;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Function;
import uk.ac.ebi.beam.Generator;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Localise;
import uk.ac.ebi.beam.Parser;
import uk.ac.ebi.beam.Topology;

public final class Graph {
    public static final int HAS_AROM = 1;
    public static final int HAS_ATM_STRO = 2;
    public static final int HAS_EXT_STRO = 4;
    public static final int HAS_BND_STRO = 8;
    public static final int HAS_STRO = 14;
    private Atom[] atoms;
    private int[] degrees;
    private int[] valences;
    private Edge[][] edges;
    private Topology[] topologies;
    private int order;
    private int size;
    private int flags = 0;
    private String title;

    Graph(int expSize) {
        this.order = 0;
        this.size = 0;
        this.edges = new Edge[expSize][];
        for (int i = 0; i < expSize; ++i) {
            this.edges[i] = new Edge[4];
        }
        this.atoms = new Atom[expSize];
        this.degrees = new int[expSize];
        this.valences = new int[expSize];
        this.topologies = new Topology[expSize];
    }

    Graph(Graph org) {
        this.order = org.order;
        this.size = org.size;
        this.flags = org.flags;
        this.atoms = Arrays.copyOf(org.atoms, this.order);
        this.valences = Arrays.copyOf(org.valences, this.order);
        this.degrees = new int[this.order];
        this.edges = new Edge[this.order][];
        this.topologies = Arrays.copyOf(org.topologies, org.topologies.length);
        for (int u = 0; u < this.order; ++u) {
            int deg = org.degrees[u];
            this.edges[u] = new Edge[deg];
            for (int j = 0; j < deg; ++j) {
                Edge e = org.edges[u][j];
                int v = e.other(u);
                if (u <= v) continue;
                Edge f = new Edge(e);
                int n = u;
                int n2 = this.degrees[n];
                this.degrees[n] = n2 + 1;
                this.edges[u][n2] = f;
                int n3 = v;
                int n4 = this.degrees[n3];
                this.degrees[n3] = n4 + 1;
                this.edges[v][n4] = f;
            }
        }
    }

    void setAtom(int i, Atom a) {
        this.atoms[i] = a;
    }

    private void ensureCapacity() {
        if (this.order >= this.atoms.length) {
            this.atoms = Arrays.copyOf(this.atoms, this.order * 2);
            this.valences = Arrays.copyOf(this.valences, this.order * 2);
            this.degrees = Arrays.copyOf(this.degrees, this.order * 2);
            this.edges = (Edge[][])Arrays.copyOf(this.edges, this.order * 2);
            this.topologies = Arrays.copyOf(this.topologies, this.order * 2);
            for (int i = this.order; i < this.edges.length; ++i) {
                this.edges[i] = new Edge[4];
            }
        }
    }

    int addAtom(Atom a) {
        this.ensureCapacity();
        this.atoms[this.order++] = a;
        return this.order - 1;
    }

    public Atom atom(int i) {
        return this.atoms[i];
    }

    void addEdge(Edge e) {
        int u = e.either();
        int v = e.other(u);
        this.ensureEdgeCapacity(u);
        this.ensureEdgeCapacity(v);
        int n = u;
        int n2 = this.degrees[n];
        this.degrees[n] = n2 + 1;
        this.edges[u][n2] = e;
        int n3 = v;
        int n4 = this.degrees[n3];
        this.degrees[n3] = n4 + 1;
        this.edges[v][n4] = e;
        int ord = e.bond().order();
        int n5 = u;
        this.valences[n5] = this.valences[n5] + ord;
        int n6 = v;
        this.valences[n6] = this.valences[n6] + ord;
        ++this.size;
    }

    private void ensureEdgeCapacity(int i) {
        if (this.degrees[i] == this.edges[i].length) {
            this.edges[i] = Arrays.copyOf(this.edges[i], this.degrees[i] + 2);
        }
    }

    int degree(int u) {
        return this.degrees[u];
    }

    int bondedValence(int u) {
        return this.valences[u];
    }

    void updateBondedValence(int i, int x) {
        int n = i;
        this.valences[n] = this.valences[n] + x;
    }

    public List<Edge> edges(int u) {
        return Arrays.asList(Arrays.copyOf(this.edges[u], this.degrees[u]));
    }

    public int[] neighbors(int u) {
        List<Edge> es = this.edges(u);
        int[] vs = new int[es.size()];
        int deg = es.size();
        for (int i = 0; i < deg; ++i) {
            vs[i] = es.get(i).other(u);
        }
        Arrays.sort(vs);
        return vs;
    }

    public boolean adjacent(int u, int v) {
        int d = this.degrees[u];
        for (int j = 0; j < d; ++j) {
            Edge e = this.edges[u][j];
            if (e.other(u) != v) continue;
            return true;
        }
        return false;
    }

    public int implHCount(int u) {
        return this.atom(u).hydrogens(this, u);
    }

    public Edge edge(int u, int v) {
        int d = this.degrees[u];
        for (int j = 0; j < d; ++j) {
            Edge e = this.edges[u][j];
            if (e.other(u) != v) continue;
            return e;
        }
        throw new IllegalArgumentException(u + ", " + v + " are not adjacent");
    }

    Edge edgeAt(int u, int j) {
        return this.edges[u][j];
    }

    void replace(Edge org, Edge rep) {
        int i;
        int u = org.either();
        int v = org.other(u);
        for (i = 0; i < this.degrees[u]; ++i) {
            if (this.edges[u][i] != org) continue;
            this.edges[u][i] = rep;
        }
        for (i = 0; i < this.degrees[v]; ++i) {
            if (this.edges[v][i] != org) continue;
            this.edges[v][i] = rep;
        }
        int ord = rep.bond().order() - org.bond().order();
        int n = u;
        this.valences[n] = this.valences[n] + ord;
        int n2 = v;
        this.valences[n2] = this.valences[n2] + ord;
    }

    void addTopology(Topology t) {
        if (t != Topology.unknown()) {
            this.topologies[t.atom()] = t;
        }
    }

    void clearTopology(int v) {
        this.topologies[v] = null;
    }

    Topology topologyOf(int u) {
        if (this.topologies[u] == null) {
            return Topology.unknown();
        }
        return this.topologies[u];
    }

    public Configuration configurationOf(int u) {
        Topology t = this.topologyOf(u);
        if (t == Topology.unknown()) {
            return t.configuration();
        }
        int[] p = new int[this.order];
        for (int i = 0; i < this.order; ++i) {
            p[i] = i;
        }
        return t.orderBy(p).configuration();
    }

    public int order() {
        return this.order;
    }

    public int size() {
        return this.size;
    }

    public static Graph fromSmiles(String smi) throws InvalidSmilesException {
        if (smi == null) {
            throw new NullPointerException("no SMILES provided");
        }
        return Parser.parse(smi);
    }

    public String toSmiles() throws InvalidSmilesException {
        return Generator.generate(this);
    }

    public String toSmiles(int[] visitedAt) throws InvalidSmilesException {
        return Generator.generate(this, visitedAt);
    }

    public Graph aromatic() {
        try {
            return AllCycles.daylightModel(this).aromaticForm();
        }
        catch (IllegalArgumentException e) {
            return AllCycles.daylightModel(this, 6).aromaticForm();
        }
    }

    public Graph resonate() {
        return Localise.resonate(this);
    }

    public Graph kekule() throws InvalidSmilesException {
        return Localise.localiseInPlace(this);
    }

    public boolean assignable() {
        return ElectronAssignment.verify(this);
    }

    public Graph permute(int[] p) {
        if (p.length != this.order) {
            throw new IllegalArgumentException("permuation size should equal |V| (order)");
        }
        Graph cpy = new Graph(this.order);
        cpy.flags = this.flags;
        cpy.order = this.order;
        cpy.size = this.size;
        for (int u = 0; u < this.order; ++u) {
            int d = this.degrees[u];
            int v = p[u];
            if (d > 4) {
                cpy.edges[v] = new Edge[d];
            }
            cpy.atoms[v] = this.atoms[u];
            cpy.valences[v] = this.valences[u];
            cpy.addTopology(this.topologyOf(u).transform(p));
            while (--d >= 0) {
                Edge e = this.edgeAt(u, d);
                if (u <= e.other(u)) continue;
                int w = p[e.other(u)];
                Edge f = new Edge(v, w, e.bond(u));
                int n = v;
                int n2 = cpy.degrees[n];
                cpy.degrees[n] = n2 + 1;
                cpy.edges[v][n2] = f;
                int n3 = w;
                int n4 = cpy.degrees[n3];
                cpy.degrees[n3] = n4 + 1;
                cpy.edges[w][n4] = f;
                ++cpy.size;
            }
        }
        return cpy.sort(new CanOrderFirst());
    }

    public Iterable<Atom> atoms() {
        return Arrays.asList(this.atoms).subList(0, this.order);
    }

    public Iterable<Edge> edges() {
        ArrayList<Edge> es = new ArrayList<Edge>(this.size);
        for (int u = 0; u < this.order; ++u) {
            int d = this.degrees[u];
            for (int i = 0; i < d; ++i) {
                Edge e = this.edges[u][i];
                if (e.other(u) >= u) continue;
                es.add(e);
            }
        }
        return Collections.unmodifiableCollection(es);
    }

    <T> T apply(Function<Graph, T> f) throws Exception {
        return f.apply(this);
    }

    void clear() {
        Arrays.fill(this.topologies, Topology.unknown());
        for (int i = 0; i < this.order; ++i) {
            this.atoms[i] = null;
            this.degrees[i] = 0;
        }
        this.order = 0;
        this.size = 0;
    }

    int getFlags(int mask) {
        return this.flags & mask;
    }

    int getFlags() {
        return this.flags;
    }

    void addFlags(int mask) {
        this.flags |= mask;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Graph sort(EdgeComparator comparator) {
        for (int u = 0; u < this.order; ++u) {
            Edge[] es = this.edges[u];
            int deg = this.degrees[u];
            for (int i = 1; i < deg; ++i) {
                int j = i - 1;
                Edge e = es[i];
                while (j >= 0 && comparator.less(this, u, e, es[j])) {
                    es[j + 1] = es[j--];
                }
                es[j + 1] = e;
            }
        }
        return this;
    }

    static final class CanOrderFirst
    implements EdgeComparator {
        CanOrderFirst() {
        }

        @Override
        public boolean less(Graph g, int u, Edge e, Edge f) {
            return e.other(u) < f.other(u);
        }
    }

    public static final class VisitHighOrderFirst
    implements EdgeComparator {
        @Override
        public boolean less(Graph g, int u, Edge e, Edge f) {
            return e.bond().order() > f.bond().order();
        }
    }

    public static final class VisitHydrogenFirst
    implements EdgeComparator {
        @Override
        public boolean less(Graph g, int u, Edge e, Edge f) {
            int v = e.other(u);
            int w = f.other(u);
            Element vElem = g.atom(v).element();
            Element wElem = g.atom(w).element();
            if (vElem == Element.Hydrogen && wElem != Element.Hydrogen) {
                return true;
            }
            if (vElem != Element.Hydrogen && wElem == Element.Hydrogen) {
                return false;
            }
            return vElem == Element.Hydrogen && g.atom(v).isotope() < g.atom(w).isotope();
        }
    }

    public static interface EdgeComparator {
        public boolean less(Graph var1, int var2, Edge var3, Edge var4);
    }
}

