/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.sgroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;

public class Sgroup {
    private final Set<IAtom> atoms = new HashSet<IAtom>();
    private final Set<IBond> bonds = new HashSet<IBond>();
    private final Set<Sgroup> parents = new HashSet<Sgroup>();
    private final Map<SgroupKey, Object> attributes = new EnumMap<SgroupKey, Object>(SgroupKey.class);

    public Sgroup() {
        this.setType(SgroupType.CtabGeneric);
    }

    Sgroup(Sgroup org) {
        this.atoms.addAll(org.atoms);
        this.bonds.addAll(org.bonds);
        this.parents.addAll(org.parents);
        this.attributes.putAll(org.attributes);
    }

    public final Set<SgroupKey> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public final void setType(SgroupType type) {
        this.putValue(SgroupKey.CtabType, (Object)type);
    }

    public final SgroupType getType() {
        return (SgroupType)((Object)this.getValue(SgroupKey.CtabType));
    }

    public final Set<IAtom> getAtoms() {
        return Collections.unmodifiableSet(this.atoms);
    }

    public final Set<IBond> getBonds() {
        return Collections.unmodifiableSet(this.bonds);
    }

    public final Set<Sgroup> getParents() {
        return Collections.unmodifiableSet(this.parents);
    }

    public final void addAtom(IAtom atom) {
        this.atoms.add(atom);
    }

    public final void addBond(IBond bond) {
        this.bonds.add(bond);
    }

    public final void addParent(Sgroup parent) {
        this.parents.add(parent);
    }

    public final void removeParents(Collection<Sgroup> parents) {
        this.parents.removeAll(parents);
    }

    public void putValue(SgroupKey key, Object val) {
        this.attributes.put(key, val);
    }

    public <T> T getValue(SgroupKey key) {
        return (T)this.attributes.get((Object)key);
    }

    public final String getSubscript() {
        return (String)this.getValue(SgroupKey.CtabSubScript);
    }

    public final void setSubscript(String label) {
        this.putValue(SgroupKey.CtabSubScript, label);
    }

    public final void addBracket(SgroupBracket bracket) {
        ArrayList<SgroupBracket> brackets = (ArrayList<SgroupBracket>)this.getValue(SgroupKey.CtabBracket);
        if (brackets == null) {
            brackets = new ArrayList<SgroupBracket>(2);
            this.putValue(SgroupKey.CtabBracket, brackets);
        }
        brackets.add(bracket);
    }

    public <T> T downcast() {
        return (T)this;
    }
}

