/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.Queue;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class FiguerasSSSRFinder {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(FiguerasSSSRFinder.class);
    int trimCounter = 0;
    private static final String PATH = "org.openscience.cdk.ringsearch.FiguerasSSSRFinderRFinder.PATH";

    public IRingSet findSSSR(IAtomContainer mol) {
        int f;
        IBond brokenBond = null;
        IChemObjectBuilder builder = mol.getBuilder();
        IRingSet sssr = builder.newInstance(IRingSet.class, new Object[0]);
        IAtomContainer molecule = builder.newInstance(IAtomContainer.class, new Object[0]);
        molecule.add(mol);
        ArrayList<IAtom> fullSet = new ArrayList<IAtom>();
        ArrayList<IAtom> trimSet = new ArrayList<IAtom>();
        ArrayList<IAtom> nodesN2 = new ArrayList<IAtom>();
        this.initPath(molecule);
        logger.debug("molecule.getAtomCount(): " + molecule.getAtomCount());
        for (f = 0; f < molecule.getAtomCount(); ++f) {
            fullSet.add(molecule.getAtom(f));
        }
        logger.debug("fullSet.size(): " + fullSet.size());
        do {
            IRing ring;
            int smallestDegree = 7;
            IAtom smallest = null;
            nodesN2.clear();
            for (f = 0; f < molecule.getAtomCount(); ++f) {
                IAtom atom = molecule.getAtom(f);
                int degree = molecule.getConnectedBondsCount(atom);
                if (degree == 0 && !trimSet.contains(atom)) {
                    logger.debug("Atom of degree 0");
                    trimSet.add(atom);
                }
                if (degree == 2) {
                    nodesN2.add(atom);
                }
                if (degree >= smallestDegree || degree <= 0) continue;
                smallest = atom;
                smallestDegree = degree;
            }
            if (smallest == null) break;
            if (smallestDegree == 1) {
                ++this.trimCounter;
                this.trim(smallest, molecule);
                trimSet.add(smallest);
                continue;
            }
            if (smallestDegree == 2) {
                IAtom[] rememberNodes = new IAtom[nodesN2.size()];
                int nodesToBreakCounter = 0;
                for (f = 0; f < nodesN2.size(); ++f) {
                    ring = this.getRing((IAtom)nodesN2.get(f), molecule);
                    if (ring == null || RingSetManipulator.ringAlreadyInSet(ring, sssr)) continue;
                    sssr.addAtomContainer(ring);
                    rememberNodes[nodesToBreakCounter] = (IAtom)nodesN2.get(f);
                    ++nodesToBreakCounter;
                }
                if (nodesToBreakCounter == 0) {
                    nodesToBreakCounter = 1;
                    rememberNodes[0] = (IAtom)nodesN2.get(0);
                }
                for (f = 0; f < nodesToBreakCounter; ++f) {
                    this.breakBond(rememberNodes[f], molecule);
                }
                if (brokenBond == null) continue;
                molecule.addBond(brokenBond);
                brokenBond = null;
                continue;
            }
            if (smallestDegree != 3 || (ring = this.getRing(smallest, molecule)) == null) continue;
            if (!RingSetManipulator.ringAlreadyInSet(ring, sssr)) {
                sssr.addAtomContainer(ring);
            }
            brokenBond = this.checkEdges(ring, molecule);
            molecule.removeElectronContainer(brokenBond);
        } while (trimSet.size() < fullSet.size());
        logger.debug("fullSet.size(): " + fullSet.size());
        logger.debug("trimSet.size(): " + trimSet.size());
        logger.debug("trimCounter: " + this.trimCounter);
        return sssr;
    }

    private IRing getRing(IAtom rootNode, IAtomContainer molecule) {
        int f;
        int OKatoms = molecule.getAtomCount();
        Queue queue = new Queue();
        ArrayList path = new ArrayList(OKatoms);
        List intersection = new ArrayList();
        List<Object> ring = new ArrayList();
        for (IAtom atom : molecule.atoms()) {
            path.add(new ArrayList());
            atom.getProperty(PATH, List.class).clear();
        }
        List<IAtom> neighbors = molecule.getConnectedAtomsList(rootNode);
        for (f = 0; f < neighbors.size(); ++f) {
            IAtom neighbor = neighbors.get(f);
            queue.push(neighbor);
            ((List)neighbor.getProperty(PATH)).add(rootNode);
            ((List)neighbor.getProperty(PATH)).add(neighbor);
        }
        while (queue.size() > 0) {
            IAtom node = (IAtom)queue.pop();
            List<IAtom> mAtoms = molecule.getConnectedAtomsList(node);
            for (f = 0; f < mAtoms.size(); ++f) {
                IAtom mAtom = mAtoms.get(f);
                if (mAtom == ((List)node.getProperty(PATH)).get(((List)node.getProperty(PATH)).size() - 2)) continue;
                if (((List)mAtom.getProperty(PATH)).size() > 0) {
                    intersection = this.getIntersection((List)node.getProperty(PATH), (List)mAtom.getProperty(PATH));
                    if (intersection.size() != 1) continue;
                    logger.debug("path1  ", (List)node.getProperty(PATH));
                    logger.debug("path2  ", (List)mAtom.getProperty(PATH));
                    logger.debug("rootNode  ", rootNode);
                    logger.debug("ring   ", ring);
                    ring = this.getUnion((List)node.getProperty(PATH), (List)mAtom.getProperty(PATH));
                    return this.prepareRing(ring, molecule);
                }
                mAtom.setProperty(PATH, new ArrayList((List)node.getProperty(PATH)));
                ((List)mAtom.getProperty(PATH)).add(mAtom);
                queue.push(mAtom);
            }
        }
        return null;
    }

    private IRing prepareRing(List vec, IAtomContainer mol) {
        int atomCount = vec.size();
        IRing ring = mol.getBuilder().newInstance(IRing.class, atomCount);
        IAtom[] atoms = new IAtom[atomCount];
        vec.toArray(atoms);
        ring.setAtoms(atoms);
        try {
            IBond b;
            for (int i = 0; i < atomCount - 1; ++i) {
                b = mol.getBond(atoms[i], atoms[i + 1]);
                if (b != null) {
                    ring.addBond(b);
                    continue;
                }
                logger.error("This should not happen.");
            }
            b = mol.getBond(atoms[0], atoms[atomCount - 1]);
            if (b != null) {
                ring.addBond(b);
            } else {
                logger.error("This should not happen either.");
            }
        }
        catch (Exception exc) {
            logger.debug(exc);
        }
        logger.debug("found Ring  ", ring);
        return ring;
    }

    private void trim(IAtom atom, IAtomContainer molecule) {
        List<IBond> bonds = molecule.getConnectedBondsList(atom);
        for (int i = 0; i < bonds.size(); ++i) {
            molecule.removeElectronContainer(bonds.get(i));
        }
    }

    private void initPath(IAtomContainer molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            IAtom atom = molecule.getAtom(i);
            atom.setProperty(PATH, new ArrayList());
        }
    }

    private List getIntersection(List<IAtom> list1, List<IAtom> list2) {
        ArrayList<IAtom> is = new ArrayList<IAtom>();
        for (int f = 0; f < list1.size(); ++f) {
            if (!list2.contains(list1.get(f))) continue;
            is.add(list1.get(f));
        }
        return is;
    }

    private List<IAtom> getUnion(List<IAtom> list1, List<IAtom> list2) {
        ArrayList<IAtom> is = new ArrayList<IAtom>(list1);
        for (int f = list2.size() - 1; f > -1; --f) {
            if (list1.contains(list2.get(f))) continue;
            is.add(list2.get(f));
        }
        return is;
    }

    private void breakBond(IAtom atom, IAtomContainer molecule) {
        for (IBond bond : molecule.bonds()) {
            if (!bond.contains(atom)) continue;
            molecule.removeElectronContainer(bond);
            break;
        }
    }

    private IBond checkEdges(IRing ring, IAtomContainer molecule) {
        IRingSet ringSet = ring.getBuilder().newInstance(IRingSet.class, new Object[0]);
        int minMaxSize = Integer.MAX_VALUE;
        int minMax = 0;
        logger.debug("Molecule: " + molecule);
        for (IBond bond : ring.bonds()) {
            molecule.removeElectronContainer(bond);
            IRing r1 = this.getRing(bond.getAtom(0), molecule);
            IRing r2 = this.getRing(bond.getAtom(1), molecule);
            logger.debug("checkEdges: " + bond);
            if (r1.getAtomCount() > r2.getAtomCount()) {
                ringSet.addAtomContainer(r1);
            } else {
                ringSet.addAtomContainer(r2);
            }
            molecule.addBond(bond);
        }
        for (int i = 0; i < ringSet.getAtomContainerCount(); ++i) {
            if (((IRing)ringSet.getAtomContainer(i)).getBondCount() >= minMaxSize) continue;
            minMaxSize = ((IRing)ringSet.getAtomContainer(i)).getBondCount();
            minMax = i;
        }
        return (IBond)ring.getElectronContainer(minMax);
    }
}

