/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;

public class PharmacophoreQueryAtom
extends Atom
implements IQueryAtom {
    private String smarts;
    private IQueryAtomContainer[] compiledSmarts;

    public PharmacophoreQueryAtom(String symbol, String smarts) {
        this.setSymbol(symbol);
        this.smarts = smarts;
        String[] subSmarts = smarts.split("\\|");
        this.compiledSmarts = new IQueryAtomContainer[subSmarts.length];
        for (int i = 0; i < this.compiledSmarts.length; ++i) {
            this.compiledSmarts[i] = SMARTSParser.parse(subSmarts[i], null);
        }
    }

    public String getSmarts() {
        return this.smarts;
    }

    IQueryAtomContainer[] getCompiledSmarts() {
        return this.compiledSmarts;
    }

    @Override
    public boolean matches(IAtom atom) {
        PharmacophoreAtom patom = (PharmacophoreAtom)atom;
        return patom.getSymbol().equals(this.getSymbol());
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getSymbol()).append(" [").append(this.getSmarts()).append(']');
        return s.toString();
    }
}

