/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.IChemObjectIO;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.SettingManager;

public abstract class ChemObjectIO
implements IChemObjectIO {
    private List<IChemObjectIOListener> listeners = new ArrayList<IChemObjectIOListener>(2);
    private SettingManager<IOSetting> settings = new SettingManager();

    public List<IChemObjectIOListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addChemObjectIOListener(IChemObjectIOListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChemObjectIOListener(IChemObjectIOListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public <S extends IOSetting> S addSetting(IOSetting setting) {
        return (S)this.settings.add(setting);
    }

    @Override
    public void addSettings(Collection<IOSetting> settings) {
        for (IOSetting setting : settings) {
            if (this.hasSetting(setting.getName())) {
                try {
                    ((IOSetting)this.getSetting(setting.getName())).setSetting(setting.getSetting());
                }
                catch (CDKException ex) {}
                continue;
            }
            this.addSetting(setting);
        }
    }

    @Override
    public boolean hasSetting(String name) {
        return this.settings.has(name);
    }

    @Override
    public <S extends IOSetting> S getSetting(String name) {
        return (S)((IOSetting)this.settings.get(name));
    }

    @Override
    public <S extends IOSetting> S getSetting(String name, Class<S> c) {
        return (S)((IOSetting)this.settings.get(name, c));
    }

    @Override
    public IOSetting[] getIOSettings() {
        return (IOSetting[])this.settings.toArray(new IOSetting[0]);
    }

    @Override
    public Collection<IOSetting> getSettings() {
        return this.settings.getSettings();
    }

    protected void fireIOSettingQuestion(IOSetting setting) {
        for (IChemObjectIOListener listener : this.listeners) {
            listener.processIOSettingQuestion(setting);
        }
    }
}

