/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.forcefield.mmff;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.forcefield.mmff.MmffAromaticTypeMapping;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.VentoFoggia;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SmartsMatchers;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.smiles.smarts.parser.TokenMgrError;

final class MmffAtomTypeMatcher {
    private final MmffAromaticTypeMapping aromaticTypes = new MmffAromaticTypeMapping();
    private final AtomTypePattern[] patterns;
    private final Map<String, String> hydrogenMap;

    MmffAtomTypeMatcher() {
        InputStream smaIn = this.getClass().getResourceAsStream("MMFFSYMB.sma");
        InputStream hdefIn = this.getClass().getResourceAsStream("mmff-symb-mapping.tsv");
        try {
            this.patterns = MmffAtomTypeMatcher.loadPatterns(smaIn);
            this.hydrogenMap = this.loadHydrogenDefinitions(hdefIn);
        }
        catch (IOException e) {
            throw new InternalError("Atom type definitions for MMFF94 Atom Types could not be loaded: " + e.getMessage());
        }
        finally {
            MmffAtomTypeMatcher.close(smaIn);
            MmffAtomTypeMatcher.close(hdefIn);
        }
    }

    String[] symbolicTypes(IAtomContainer container) {
        GraphUtil.EdgeToBondMap bonds = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        int[][] graph = GraphUtil.toAdjList(container, bonds);
        return this.symbolicTypes(container, graph, bonds, new HashSet<IBond>());
    }

    String[] symbolicTypes(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bonds, Set<IBond> mmffArom) {
        String[] symbs = new String[container.getAtomCount()];
        this.checkPreconditions(container);
        this.assignPreliminaryTypes(container, symbs);
        this.aromaticTypes.assign(container, symbs, bonds, graph, mmffArom);
        this.fixNCNTypes(symbs, graph);
        this.assignHydrogenTypes(container, symbs, graph);
        return symbs;
    }

    private void fixNCNTypes(String[] symbs, int[][] graph) {
        for (int v = 0; v < graph.length; ++v) {
            if (!"NCN+".equals(symbs[v])) continue;
            boolean foundCNN = false;
            for (int w : graph[v]) {
                foundCNN = foundCNN || "CNN+".equals(symbs[w]) || "CIM+".equals(symbs[w]);
            }
            if (foundCNN) continue;
            symbs[v] = "NC=N";
        }
    }

    private void checkPreconditions(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            if (atom.getImplicitHydrogenCount() == null || atom.getImplicitHydrogenCount() != 0) {
                throw new IllegalArgumentException("Hydrogens should be unsuppressed (explicit)");
            }
            if (!atom.getFlag(32)) continue;
            throw new IllegalArgumentException("No aromatic flags should be set");
        }
    }

    private void assignHydrogenTypes(IAtomContainer container, String[] symbs, int[][] graph) {
        for (int v = 0; v < graph.length; ++v) {
            if (!container.getAtom(v).getSymbol().equals("H") || graph[v].length != 1) continue;
            int w = graph[v][0];
            symbs[v] = this.hydrogenMap.get(symbs[w]);
        }
    }

    private void assignPreliminaryTypes(IAtomContainer container, String[] symbs) {
        SmartsMatchers.prepare(container, true);
        for (AtomTypePattern matcher : this.patterns) {
            Iterator iterator = matcher.matches(container).iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                if (symbs[idx] != null) continue;
                symbs[idx] = matcher.symb;
            }
        }
    }

    static AtomTypePattern[] loadPatterns(InputStream smaIn) throws IOException {
        ArrayList<AtomTypePattern> matchers = new ArrayList<AtomTypePattern>();
        BufferedReader br = new BufferedReader(new InputStreamReader(smaIn));
        String line = null;
        while ((line = br.readLine()) != null) {
            if (MmffAtomTypeMatcher.skipLine(line)) continue;
            String[] cols = line.split(" ");
            String sma = cols[0];
            String symb = cols[1];
            try {
                QueryAtomContainer container = SMARTSParser.parse(sma, null);
                matchers.add(new AtomTypePattern(VentoFoggia.findSubstructure(container), symb));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(line + " could not be loaded: " + e.getMessage());
            }
            catch (TokenMgrError e) {
                throw new IOException(line + " could not be loaded: " + e.getMessage());
            }
        }
        return matchers.toArray(new AtomTypePattern[matchers.size()]);
    }

    private Map<String, String> loadHydrogenDefinitions(InputStream hdefIn) throws IOException {
        HashMap<String, String> hdefs = new HashMap<String, String>(200);
        BufferedReader br = new BufferedReader(new InputStreamReader(hdefIn));
        br.readLine();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] cols = line.split("\t");
            hdefs.put(cols[0].trim(), cols[3].trim());
        }
        return hdefs;
    }

    private static boolean skipLine(String line) {
        return line.isEmpty() || line.charAt(0) == '*' || line.charAt(0) == '$';
    }

    private static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final class AtomTypePattern {
        private final Pattern pattern;
        private final String symb;

        private AtomTypePattern(Pattern pattern, String symb) {
            this.pattern = pattern;
            this.symb = symb;
        }

        private Set<Integer> matches(IAtomContainer container) {
            HashSet<Integer> matchedIdx = new HashSet<Integer>();
            for (int[] mapping : this.pattern.matchAll(container)) {
                matchedIdx.add(mapping[0]);
            }
            return matchedIdx;
        }
    }
}

