/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.StandardSubstructureSets;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class SubstructureFingerprinter
implements IFingerprinter {
    private String[] smarts;

    public SubstructureFingerprinter() {
        try {
            this.smarts = StandardSubstructureSets.getFunctionalGroupSMARTS();
        }
        catch (Exception e) {
            this.smarts = null;
        }
    }

    public SubstructureFingerprinter(String[] smarts) {
        this.smarts = smarts;
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        if (this.smarts == null) {
            throw new CDKException("No substructures were defined");
        }
        int bitsetLength = this.smarts.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SMARTSQueryTool sqt = new SMARTSQueryTool("C", atomContainer.getBuilder());
        for (int i = 0; i < this.smarts.length; ++i) {
            String pattern = this.smarts[i];
            sqt.setSmarts(pattern);
            boolean status = sqt.matches(atomContainer);
            if (!status) continue;
            fingerPrint.set(i, true);
        }
        return new BitSetFingerprint(fingerPrint);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return this.smarts.length;
    }

    public String getSubstructure(int bitIndex) {
        return this.smarts[bitIndex];
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

