/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import junit.textui.TestRunner;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.util.io.UniquePrintStream;

public class TestSuite
extends junit.framework.TestSuite {
    private SortedMap<String, Format> bitmapFormats;
    private SortedMap<String, Format> vectorFormats;
    private static final String jiraURL = "http://bugs.freehep.org/secure/IssueNavigator.jspa?reset=true&mode=hide&sorter/order=DESC&sorter/field=priority&resolutionIds=-1";
    private static final int jiraProductId = 10170;
    private List<Test> tests;
    private static final String gioPackage = "org.freehep.graphicsio.";
    private static final String testPackage = "org.freehep.graphicsio.test.";
    private static final String testDir = "target/site/test-output/";
    private String testOutDir;
    private String os;
    private String jdk;
    private boolean local = !System.getProperty("vg.local", "true").equals("false");

    protected TestSuite() {
        super("GraphicsIO Test Suite");
        this.bitmapFormats = new TreeMap<String, Format>();
        this.bitmapFormats.put("BMP".toLowerCase(), new Format("BMP", null, "freehep-graphicsio-tests", true, true, 10241, null));
        this.bitmapFormats.put("GIF".toLowerCase(), new Format("GIF", null, "freehep-graphicsio-tests", true, true, 10241, null));
        this.bitmapFormats.put("JPG".toLowerCase(), new Format("JPG", null, "freehep-graphicsio-tests", true, true, 10241, null));
        this.bitmapFormats.put("PNG".toLowerCase(), new Format("PNG", null, "freehep-graphicsio-tests", true, true, 10241, null));
        this.bitmapFormats.put("WBMP".toLowerCase(), new Format("WBMP", null, "freehep-graphicsio-tests", true, true, 10241, null));
        this.vectorFormats = new TreeMap<String, Format>();
        this.vectorFormats.put("EMF".toLowerCase(), new Format("EMF", null, null, true, false, 10231, null));
        this.vectorFormats.put("JAVA".toLowerCase(), new Format("JAVA", null, null, false, false, 10238, "org/freehep/graphicsio/java/test"));
        this.vectorFormats.put("PDF".toLowerCase(), new Format("PDF", null, null, true, false, 10235, null));
        this.vectorFormats.put("PS".toLowerCase(), new Format("PS", null, null, true, false, 10232, null));
        this.vectorFormats.put("SVG".toLowerCase(), new Format("SVG", null, null, true, false, 10236, null));
        this.vectorFormats.put("SWF".toLowerCase(), new Format("SWF", null, null, true, false, 10237, null));
        boolean on = true;
        boolean onMacOSXandJDK15 = System.getProperty("os.name").equals("Mac OS X") && System.getProperty("java.version").startsWith("1.5");
        this.tests = new ArrayList<Test>();
        this.tests.add(new Test("TestAll", on));
        this.tests.add(new Test("TestClip", on));
        this.tests.add(new Test("TestColors", on));
        this.tests.add(new Test("TestCustomStrokes", on));
        this.tests.add(new Test("TestFonts", on));
        this.tests.add(new Test("TestFontDerivation", on));
        this.tests.add(new Test("TestGraphicsContexts", on));
        this.tests.add(new Test("TestHistogram", on));
        this.tests.add(new Test("TestHTML", on));
        this.tests.add(new Test("TestImages", on));
        this.tests.add(new Test("TestImage2D", on));
        this.tests.add(new Test("TestLabels", on));
        this.tests.add(new Test("TestLineStyles", on));
        this.tests.add(new Test("TestOffset", on));
        this.tests.add(new Test("TestPaint", on));
        this.tests.add(new Test("TestPrintColors", on));
        this.tests.add(new Test("TestRenderingHints", on));
        this.tests.add(new Test("TestResolution", on));
        this.tests.add(new Test("TestScatterPlot", on));
        this.tests.add(new Test("TestShapes", on));
        this.tests.add(new Test("TestSymbols2D", on));
        this.tests.add(new Test("TestTaggedString", on));
        this.tests.add(new Test("TestText2D", on));
        this.tests.add(new Test("TestTransforms", on));
        this.tests.add(new Test("TestTransparency", on));
        this.os = System.getProperty("os.name", "OS");
        if (this.os.equals("Mac OS X")) {
            this.os = "MacOSX";
        } else if (this.os.startsWith("Windows")) {
            this.os = "Windows";
        }
        this.jdk = System.getProperty("java.version", "0.0");
        int dot = this.jdk.indexOf(46);
        if (dot > 0 && (dot = this.jdk.indexOf(46, dot + 1)) > 0) {
            this.jdk = this.jdk.substring(0, dot);
        }
        this.jdk = "JDK-" + this.jdk;
        this.testOutDir = testDir + this.os + "/" + this.jdk + "/";
    }

    protected void addTests(Format fmt, Properties properties) {
        if (fmt == null || !fmt.isEnabled()) {
            return;
        }
        for (Test test : this.tests) {
            if (test.isEnabled()) {
                this.addTest((junit.framework.Test)new TestCase(test.getName(), fmt, this.testOutDir, properties));
                this.writeHTML(test, fmt, this.os, this.jdk);
                continue;
            }
            System.err.println("NOTE: " + test.getName() + " disabled for " + fmt.getName() + ".");
        }
    }

    protected void addTests(String formatName, Properties properties) {
        Format fmt = (Format)this.bitmapFormats.get(formatName.toLowerCase());
        if (fmt == null) {
            fmt = (Format)this.vectorFormats.get(formatName.toLowerCase());
        }
        this.addTests(fmt, properties);
    }

    protected void addTests(String formatName) {
        this.addTests(formatName, null);
    }

    protected void addTests(String[] args) {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                this.addTests(args[i]);
            }
        } else {
            Format fmt;
            Iterator<String> i = this.bitmapFormats.keySet().iterator();
            while (i.hasNext()) {
                fmt = (Format)this.bitmapFormats.get(i.next());
                this.addTests(fmt, null);
            }
            i = this.vectorFormats.keySet().iterator();
            while (i.hasNext()) {
                fmt = (Format)this.vectorFormats.get(i.next());
                this.addTests(fmt, null);
            }
        }
    }

    private void writeHTML(Test test, Format fmt, String os, String jdk) {
        String site = "../../../../";
        String css = site + "css";
        String top = site + (this.local ? "../../" : "") + "../";
        String refFormat = "PNG".toLowerCase();
        String testSite = top + "freehep-graphicsio-tests/" + (this.local ? "target/site/" : "");
        String ref = testSite + "ref-output/" + refFormat + "/";
        String cloud = testSite + "images/" + "cloudy.jpg";
        String title = (this.local ? "[LOCAL] " : "") + "VectorGraphics " + fmt.getName() + " " + test.getName();
        String freehep = "http://java.freehep.org/";
        String freehepImage = freehep + "images/sm-freehep.gif";
        String url = freehep + "vectorgraphics/freehep-graphicsio-" + fmt.getLowerCaseName();
        String out = this.testOutDir + fmt.getTestDir() + "/";
        String baseDir = System.getProperty("basedir");
        if (baseDir != null) {
            out = baseDir + "/" + out;
        }
        try {
            int nextIndex;
            int previousIndex;
            Format value;
            ExportFileType.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            List<ExportFileType> fileTypes = ExportFileType.getExportFileTypes(fmt.getLowerCaseName());
            if (fileTypes.size() <= 0) {
                throw new AssertionFailedError("No ExportFileType found for format '" + fmt.getLowerCaseName() + "'");
            }
            String[] mimeTypes = fileTypes.get(0).getMIMETypes();
            if (mimeTypes.length <= 0) {
                throw new AssertionFailedError("No MimeTypes found for ExportFileType '" + fmt.getLowerCaseName() + "'");
            }
            new File(out).mkdirs();
            PrintWriter w = new PrintWriter(new FileWriter(out + test.getName() + ".html"));
            w.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            w.println("<html>");
            w.println("    <head>");
            w.println("        <title>" + title + "</title>");
            w.println("        <style type=\"text/css\" media=\"all\">");
            w.println("          @import url(\"" + css + "/maven-base.css\");");
            w.println("          @import url(\"" + css + "/maven-theme.css\");");
            w.println("          @import url(\"" + css + "/site.css\");");
            w.println("        </style>");
            w.println("        <link rel=\"stylesheet\" href=\"" + css + "/print.css\" type=\"text/css\" media=\"print\" />");
            w.println("        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />");
            w.println("      </head>");
            w.println("      <body class=\"composite\">");
            w.println("        <div id=\"banner\">");
            w.println("          <a href=\"" + url + "\" id=\"bannerLeft\">");
            w.println("            " + (this.local ? "[LOCAL] " : "") + "FreeHEP VectorGraphics Test " + fmt.getName());
            w.println("          </a>");
            w.println("          <a href=\"" + freehep + "\" id=\"bannerRight\">");
            w.println("            <img src=\"" + freehepImage + "\" alt=\"\" />");
            w.println("          </a>");
            w.println("          <div class=\"clear\">");
            w.println("            <hr/>");
            w.println("          </div>");
            w.println("        </div>");
            w.println("        <div id=\"breadcrumbs\">");
            w.println("          <div class=\"xleft\">Last Run: " + new Date() + "</div>");
            w.println("          <div class=\"xright\"><a href=\"" + freehep + "\">FreeHEP</a>");
            w.println("            |");
            w.println("            <a href=\"http://jas.freehep.org/\">JAS</a>");
            w.println("            |");
            w.println("            <a href=\"http://wired.freehep.org/\">WIRED</a>");
            w.println("          </div>");
            w.println("          <div class=\"clear\">");
            w.println("            <hr/>");
            w.println("          </div>");
            w.println("        </div>");
            w.println("        <div id=\"leftColumn\">");
            w.println("          <div id=\"navcolumn\">");
            if (!this.local) {
                w.println("            <h5><a href=\"" + top + "index.html" + "\">Back</a></h5>");
            }
            w.println("            <h5>Operating System</h5>");
            w.println("            <ul>");
            String[] oss = new String[]{"Windows", "Linux", "MacOSX"};
            for (int i = 0; i < oss.length; ++i) {
                if (this.local && !os.equals(oss[i])) continue;
                w.println("              <li class=\"none\">");
                if (os.equals(oss[i])) {
                    w.println("                <strong>");
                }
                w.println("                  <a href=\"" + top + fmt.getModuleName() + "/" + (this.local ? "target/site/" : "") + "test-output/" + oss[i] + "/" + jdk + "/" + fmt.getLowerCaseName() + "/" + test.getName() + ".html\">" + oss[i] + "</a>");
                if (os.equals(oss[i])) {
                    w.println("                </strong>");
                }
                w.println("              </li>");
            }
            w.println("            </ul>");
            w.println("            <h5>Java</h5>");
            w.println("            <ul>");
            w.println("              <li class=\"none\">");
            String[] jdks = new String[]{"JDK-1.5", "JDK-1.6"};
            for (int i = 0; i < jdks.length; ++i) {
                if (this.local && !jdk.equals(jdks[i])) continue;
                w.println("              <li class=\"none\">");
                if (jdk.equals(jdks[i])) {
                    w.println("                <strong>");
                }
                w.println("                  <a href=\"" + top + fmt.getModuleName() + "/" + (this.local ? "target/site/" : "") + "test-output/" + os + "/" + jdks[i] + "/" + fmt.getLowerCaseName() + "/" + test.getName() + ".html\">" + jdks[i] + "</a>");
                if (jdk.equals(jdks[i])) {
                    w.println("                </strong>");
                }
                w.println("              </li>");
            }
            w.println("            </ul>");
            w.println("            <h5>Vector Formats</h5>");
            w.println("            <ul>");
            for (String key : this.vectorFormats.keySet()) {
                w.println("              <li class=\"none\">");
                if (key.equalsIgnoreCase(fmt.getLowerCaseName())) {
                    w.println("                <strong>");
                }
                value = (Format)this.vectorFormats.get(key);
                w.print("                  ");
                if (value.isEnabled()) {
                    w.print("<a href=\"" + top + value.getModuleName() + "/" + (this.local ? "target/site/" : "") + "test-output/" + os + "/" + jdk + "/" + key + "/" + test.getName() + ".html\">");
                }
                w.print(value.getName());
                if (value.isEnabled()) {
                    w.print("</a>");
                }
                w.println();
                if (key.equalsIgnoreCase(fmt.getLowerCaseName())) {
                    w.println("                </strong>");
                }
                w.println("              </li>");
            }
            w.println("            </ul>");
            w.println("            <h5>Bitmap Formats</h5>");
            w.println("            <ul>");
            for (String key : this.bitmapFormats.keySet()) {
                w.println("              <li class=\"none\">");
                if (key.equalsIgnoreCase(fmt.getLowerCaseName())) {
                    w.println("                <strong>");
                }
                value = (Format)this.bitmapFormats.get(key);
                w.print("                  ");
                if (value.isEnabled()) {
                    w.print("<a href=\"" + top + value.getModuleName() + "/" + (this.local ? "target/site/" : "") + "test-output/" + os + "/" + jdk + "/" + key + "/" + test.getName() + ".html\">");
                }
                w.print(value.getName());
                if (value.isEnabled()) {
                    w.print("</a>");
                }
                w.println();
                if (key.equalsIgnoreCase(fmt.getLowerCaseName())) {
                    w.println("                </strong>");
                }
                w.println("              </li>");
            }
            w.println("            </ul>");
            w.println("            <h5>" + fmt.getName() + " Tests</h5>");
            w.println("            <ul>");
            for (Test t : this.tests) {
                w.println("              <li class=\"none\">");
                if (t.equals(test)) {
                    w.println("                <strong>");
                }
                w.print("                ");
                if (t.isEnabled()) {
                    w.print("<a href=\"" + t.getName() + ".html\">");
                }
                w.print(t.getName());
                if (t.isEnabled()) {
                    w.print("</a>");
                }
                w.println();
                if (t.equals(test)) {
                    w.println("                </strong>");
                }
                w.println("              </li>");
            }
            w.println("            </ul>");
            w.println("            <h5>" + fmt.getName() + " Links</h5>");
            w.println("            <ul>");
            w.println("              <li><a href=\"http://bugs.freehep.org/secure/IssueNavigator.jspa?reset=true&mode=hide&sorter/order=DESC&sorter/field=priority&resolutionIds=-1&pid=10170&component=" + fmt.getJiraId() + "\">Issues</a></li>");
            w.println("            </ul>");
            w.println("            <a href=\"" + freehep + "\" title=\"Built by FreeHEP\" id=\"poweredBy\">");
            w.println("              <img alt=\"Built by FreeHEP\" src=\"" + freehepImage + "\"></img>");
            w.println("            </a>");
            w.println("          </div>");
            w.println("        </div>");
            w.println("        <div id=\"bodyColumn\">");
            w.println("          <div id=\"contentBox\">");
            w.println("            <div class=\"section\">");
            w.println("              <h2>" + (this.local ? "[LOCAL] " : "") + test.getName() + " " + fmt.getName() + "</h2>");
            w.println("              <table class=\"bodyTable\">");
            w.println("                <tr class=\"a\">");
            w.println("                  <th>" + fmt.getName() + "</th>");
            w.println("                  <th>Reference (" + refFormat.toUpperCase() + ")</th>");
            w.println("                </tr>");
            w.println("                <tr class=\"a\">");
            w.println("                  <td><a href=\"" + test.getName() + "." + fmt.getExtension() + "\">" + test.getName() + "." + fmt.getExtension() + "</a></td>");
            w.println("                  <td><a href=\"" + ref + test.getName() + "." + refFormat + "\">" + test.getName() + "." + refFormat + "</a></td>");
            w.println("                </tr>");
            w.println("                <tr class=\"a\">");
            Test[] testArray = this.tests.toArray(new Test[0]);
            for (int testIndex = 0; testIndex < testArray.length && !testArray[testIndex].equals(test); ++testIndex) {
            }
            for (previousIndex = testIndex - 1; previousIndex >= 0 && !testArray[previousIndex].isEnabled(); --previousIndex) {
            }
            if (previousIndex >= 0) {
                w.println("                  <td><a href=\"" + testArray[previousIndex].getName() + ".html\">previous</a></td>");
            } else {
                w.println("                  <td/>");
            }
            for (nextIndex = testIndex + 1; nextIndex < testArray.length && !testArray[nextIndex].isEnabled(); ++nextIndex) {
            }
            if (nextIndex < testArray.length) {
                w.println("                  <td><a href=\"" + testArray[nextIndex].getName() + ".html\">next</a></td>");
            } else {
                w.println("                  <td/>");
            }
            w.println("                </tr>");
            w.println("                <tr class=\"b\">");
            w.print("                  ");
            w.print("<td background=\"" + cloud + "\">");
            w.print("<object type=\"" + mimeTypes[0] + "\" name=\"" + test.getName() + "\" data=\"" + test.getName() + "." + fmt.getExtension() + "\" width=\"" + 600 + "\" height=\"" + 600 + "\">");
            w.print("<param name=\"wmode\" value=\"transparent\"/>");
            w.print("Image not embeddable: " + mimeTypes[0]);
            w.print("</object>");
            w.println("</td>");
            w.println("                  <td background=\"" + cloud + "\"><img src=\"" + ref + test.getName() + "." + refFormat + "\"/></td>");
            w.println("                </tr>");
            w.println("             </table>");
            w.println("           </div>");
            w.println("          </div>");
            w.println("        </div>");
            w.println("        <div class=\"clear\">");
            w.println("          <hr/>");
            w.println("        </div>");
            w.println("        <div id=\"footer\">");
            w.println("          <div class=\"xright\">&#169;");
            w.println("              2000-2007");
            w.println("              FreeHEP");
            w.println("          </div>");
            w.println("          <div class=\"clear\">");
            w.println("            <hr/>");
            w.println("          </div>");
            w.println("        </div>");
            w.println("      </body>");
            w.println("    </html>");
            w.close();
        }
        catch (IOException e) {
            System.err.println("Could not write " + out);
        }
    }

    public static TestSuite suite() {
        StringTokenizer st = new StringTokenizer(System.getProperty("args", ""), " ");
        ArrayList<String> argList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String arg = st.nextToken();
            System.out.println(arg);
            argList.add(arg);
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        TestSuite suite = new TestSuite();
        suite.addTests(args);
        return suite;
    }

    public static void main(String[] args) {
        UniquePrintStream stderr = new UniquePrintStream(System.err);
        System.setErr(stderr);
        TestSuite suite = new TestSuite();
        suite.addTests(args);
        TestRunner.run((junit.framework.Test)suite);
        stderr.finish();
    }

    public static class TestCase
    extends junit.framework.TestCase {
        private String name;
        private String fullName;
        private String pkg;
        private String testOutDir;
        private Format fmt;
        private Properties properties;

        public TestCase(String name, Format fmt, String testOutDir, Properties properties) {
            super("GraphicsIO Test for org.freehep.graphicsio.test." + name + " in " + fmt.getName());
            this.fullName = TestSuite.testPackage + name;
            int dot = this.fullName.lastIndexOf(".");
            this.name = dot < 0 ? this.fullName : this.fullName.substring(dot + 1);
            this.fmt = fmt;
            this.pkg = TestSuite.gioPackage + fmt.getLowerCaseName();
            this.testOutDir = testOutDir;
            this.properties = properties;
        }

        protected void runTest() throws Throwable {
            Object args;
            String base = "src/test/resources/";
            String baseDir = System.getProperty("basedir");
            if (baseDir != null) {
                base = baseDir + "/" + base;
            }
            String out = this.testOutDir + this.fmt.getTestDir() + "/";
            if (baseDir != null) {
                out = baseDir + "/" + out;
            }
            new File(out).mkdirs();
            Class<?> cls = Class.forName(this.fullName);
            String targetName = out + this.name + "." + this.fmt.getExtension();
            if (this.fmt.isBitmap()) {
                args = Array.newInstance(String.class, 3);
                Array.set(args, 0, ImageGraphics2D.class.getName());
                Array.set(args, 1, this.fmt.getLowerCaseName());
                Array.set(args, 2, targetName);
            } else {
                args = Array.newInstance(String.class, 2);
                Array.set(args, 0, this.pkg + "." + this.fmt.getName() + "Graphics2D");
                Array.set(args, 1, targetName);
            }
            Constructor<?> constructor = cls.getConstructor(args.getClass());
            Object test = constructor.newInstance(args);
            Method runTest = test.getClass().getMethod("runTest", Properties.class);
            runTest.invoke(test, this.properties);
        }
    }

    class Test {
        private String name;
        private boolean enabled;

        public Test(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    class Format {
        private String name;
        private String lowerCaseName;
        private String upperCaseName;
        private String extension;
        private String moduleName;
        private boolean enabled;
        private boolean bitmap;
        private int jiraId;
        private String testDir;

        public Format(String name, String extension, String moduleName, boolean enabled, boolean bitmap, int jiraId, String testDir) {
            this.name = name;
            this.lowerCaseName = name.toLowerCase();
            this.upperCaseName = name.toUpperCase();
            this.extension = extension;
            this.moduleName = moduleName;
            this.enabled = enabled;
            this.bitmap = bitmap;
            this.jiraId = jiraId;
            this.testDir = testDir;
        }

        public String getName() {
            return this.name;
        }

        public String getLowerCaseName() {
            return this.lowerCaseName;
        }

        public String getUpperCaseName() {
            return this.upperCaseName;
        }

        public String getExtension() {
            return this.extension != null ? this.extension : this.lowerCaseName;
        }

        public String getModuleName() {
            return this.moduleName != null ? this.moduleName : "freehep-graphicsio-" + this.lowerCaseName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isBitmap() {
            return this.bitmap;
        }

        public int getJiraId() {
            return this.jiraId;
        }

        public String getTestDir() {
            return this.testDir != null ? this.testDir : this.lowerCaseName;
        }
    }
}

