/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;

public abstract class BaseGraphMaker
implements GraphMaker {
    private int counter = 0;
    protected ReificationStyle style;
    private Graph defaultGraph;

    public BaseGraphMaker(ReificationStyle style) {
        this.style = style;
    }

    @Override
    public ReificationStyle getReificationStyle() {
        return this.style;
    }

    @Override
    public Graph getGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = this.createGraph();
        }
        return this.defaultGraph;
    }

    @Override
    public Graph openGraph() {
        if (this.defaultGraph == null) {
            throw new DoesNotExistException("no default graph in this GraphMaker [" + this.getClass() + "]");
        }
        return this.defaultGraph;
    }

    @Override
    public Graph createGraph() {
        return this.createGraph("anon_" + this.counter++ + "", false);
    }

    @Override
    public Graph createGraph(String name) {
        return this.createGraph(name, false);
    }

    @Override
    public Graph openGraph(String name) {
        return this.openGraph(name, false);
    }
}

