/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.type.RadicalSiteRrAlphaReactionTest")
public class RadicalSiteRrAlphaReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RadicalSiteRrAlphaReaction.class);

    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#RadicalSiteRrAlpha", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testInitiate_IAtomContainerSet_IAtomContainerSet")
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: RadicalSiteRrAlphaReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("RadicalSiteRrAlphaReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("RadicalSiteRrAlphaReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactant);
        CDKHueckelAromaticityDetector.detectAromaticity(reactant);
        AllRingsFinder arf = new AllRingsFinder();
        IRingSet ringSet = arf.findAllRings(reactant);
        for (int ir = 0; ir < ringSet.getAtomContainerCount(); ++ir) {
            IRing ring = (IRing)ringSet.getAtomContainer(ir);
            for (int jr = 0; jr < ring.getAtomCount(); ++jr) {
                IAtom aring = ring.getAtom(jr);
                aring.setFlag(1, true);
            }
        }
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        HOSECodeGenerator hcg = new HOSECodeGenerator();
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(10) || reactant.getConnectedSingleElectronsCount(atomi) != 1) continue;
            hcg.getSpheres(reactant, atomi, 1, true);
            List<IAtom> atom1s = hcg.getNodesInSphere(1);
            hcg.getSpheres(reactant, atomi, 2, true);
            for (IAtom atoml : hcg.getNodesInSphere(2)) {
                if (atoml == null || !atoml.getFlag(10) || atoml.getFlag(1) || (atoml.getFormalCharge() == CDKConstants.UNSET ? 0 : atoml.getFormalCharge()) != 0 || atoml.equals("H") || reactant.getMaximumBondOrder(atoml) != IBond.Order.SINGLE) continue;
                for (IAtom atomR : reactant.getConnectedAtomsList(atoml)) {
                    if (atom1s.contains(atomR) || !reactant.getBond(atomR, atoml).getFlag(10) || !atomR.getFlag(10) || (atomR.getFormalCharge() == CDKConstants.UNSET ? 0 : atomR.getFormalCharge()) != 0) continue;
                    ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                    atomList.add(atomR);
                    atomList.add(atomi);
                    atomList.add(atoml);
                    ArrayList<IBond> bondList = new ArrayList<IBond>();
                    bondList.add(reactant.getBond(atomR, atoml));
                    IAtomContainerSet moleculeSet = reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    moleculeSet.addAtomContainer(reactant);
                    IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                    if (reaction == null) continue;
                    setOfReactions.addReaction(reaction);
                }
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        HOSECodeGenerator hcg = new HOSECodeGenerator();
        for (IAtom atomi : reactant.atoms()) {
            if (reactant.getConnectedSingleElectronsCount(atomi) != 1) continue;
            hcg.getSpheres(reactant, atomi, 1, true);
            List<IAtom> atom1s = hcg.getNodesInSphere(1);
            hcg.getSpheres(reactant, atomi, 2, true);
            for (IAtom atoml : hcg.getNodesInSphere(2)) {
                if (atoml == null || atoml.getFlag(1) || (atoml.getFormalCharge() == CDKConstants.UNSET ? 0 : atoml.getFormalCharge()) != 0 || atoml.equals("H") || reactant.getMaximumBondOrder(atoml) != IBond.Order.SINGLE) continue;
                for (IAtom atomR : reactant.getConnectedAtomsList(atoml)) {
                    if (atom1s.contains(atomR) || (atomR.getFormalCharge() == CDKConstants.UNSET ? 0 : atomR.getFormalCharge()) != 0) continue;
                    atomi.setFlag(10, true);
                    atoml.setFlag(10, true);
                    atomR.setFlag(10, true);
                    reactant.getBond(atomR, atoml).setFlag(10, true);
                }
            }
        }
    }
}

